/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * PropertyHelper.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.core;

import java.beans.PropertyDescriptor;
import java.io.File;

/**
 * Helper class for updating properties of objects.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4584 $
 */
public class PropertyHelper {

  /**
   * Converts the variable value into the appropriate object, if possible.
   *
   * @param desc	the property descriptor to use
   * @param value	the string to convert
   * @return		the converted value or null if it cannot be converted
   */
  public static Object convertVariableValue(PropertyDescriptor desc, String value) {
    Object	result;
    Class	cls;

    result = null;
    cls    = desc.getReadMethod().getReturnType();

    // boolean
    if ((cls == Boolean.class) || (cls == Boolean.TYPE))
      result = new Boolean(value);
    // byte
    else if ((cls == Byte.class) || (cls == Byte.TYPE))
      result = new Byte(value);
    // short
    else if ((cls == Short.class) || (cls == Short.TYPE))
      result = new Short(value);
    // integer
    else if ((cls == Integer.class) || (cls == Integer.TYPE))
      result = new Integer(value);
    // long
    else if ((cls == Long.class) || (cls == Long.TYPE))
      result = new Long(value);
    // float
    else if ((cls == Float.class) || (cls == Float.TYPE))
      result = new Float(value);
    // double
    else if ((cls == Double.class) || (cls == Double.TYPE))
      result = new Double(value);
    // String
    else if (cls == String.class)
      result = value;
    // File
    else if (cls == File.class)
      result = new File(value);

    if (result == null)
      System.err.println(
	  "Class " + cls.getName() + " not (yet) supported for setting property!");

    return result;
  }

}
