/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * MultiLineValueDialog.java
 * Copyright (C) 2012 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.goe;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Frame;

import javax.swing.JLabel;
import javax.swing.JPanel;

import adams.gui.core.TextEditorPanel;
import adams.gui.dialog.AbstractApprovalDialog;

/**
 * Dialog for entering multiple values (one per line) for MultiSelectionEditor
 * editors that can parse objects from text.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4584 $
 * @see MultiSelectionEditor
 */
public class MultiLineValueDialog
  extends AbstractApprovalDialog {

  /** for serialization. */
  private static final long serialVersionUID = -3749635663753848815L;

  /** encloses all panels. */
  protected JPanel m_PanelAll;
  
  /** the panel for the info text. */
  protected JPanel m_PanelInfo;

  /** the panel at the bottom for additional options. */
  protected JPanel m_PanelBottom;
  
  /** the label with the info text. */
  protected JLabel m_LabelInfo;
  
  /** the editor for entering the text. */
  protected TextEditorPanel m_Editor;

  /**
   * Default constructor.
   */
  public MultiLineValueDialog() {
    super((Frame) null);
  }

  /**
   * Initializes the widgets.
   */
  protected void initGUI() {
    super.initGUI();

    m_Editor = new TextEditorPanel();

    m_LabelInfo = new JLabel("Enter the values, one per line:");
    m_PanelInfo = new JPanel(new FlowLayout(FlowLayout.LEFT));
    m_PanelInfo.add(m_LabelInfo);

    m_PanelBottom = new JPanel();
    m_PanelBottom.setVisible(false);

    m_PanelAll = new JPanel(new BorderLayout());
    m_PanelAll.add(m_PanelInfo, BorderLayout.NORTH);
    m_PanelAll.add(m_Editor, BorderLayout.CENTER);
    m_PanelAll.add(m_PanelBottom, BorderLayout.SOUTH);

    getContentPane().add(m_PanelAll, BorderLayout.CENTER);
    setModalityType(ModalityType.DOCUMENT_MODAL);
    setSize(400, 300);
  }
  
  /**
   * Sets the info text. 
   * 
   * @param value	the info text
   */
  public void setInfoText(String value) {
    m_LabelInfo.setText(value);
  }
  
  /**
   * Returns the current info text.
   * 
   * @return		the info text
   */
  public String getInfoText() {
    return m_LabelInfo.getText();
  }
  
  /**
   * Returns the panel at the bottom (not visible by default). Can be used
   * for further options.
   * 
   * @return		the panel
   */
  public JPanel getBottomPanel() {
    return m_PanelBottom;
  }
  
  /**
   * Sets the string content to display.
   * 
   * @param value	the text to display
   */
  public void setContent(String value) {
    m_Editor.setContent(value);
  }
  
  /**
   * Returns the string content that was entered.
   * 
   * @return		the entered text
   */
  public String getContent() {
    return m_Editor.getContent();
  }
}
