/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * EventsTree.java
 * Copyright (C) 2012 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.goe.eventstree;

import java.util.Enumeration;

import javax.swing.tree.TreePath;

import adams.gui.core.BaseTreeNode;
import adams.gui.goe.actorpathtree.ActorPathTree;

/**
 * Displays classes in a tree structure.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4584 $
 */
public class EventsTree
  extends ActorPathTree<EventsNode> {

  /** for serialization. */
  private static final long serialVersionUID = 6343911349519910301L;

  /**
   * Initializes the tree with no classes.
   */
  public EventsTree() {
    super();
  }

  /**
   * Returns a new instance of a node.
   *
   * @param label	the label to use
   * @return		the new node
   * @see		#newNode(String)
   */
  protected EventsNode newNodeInstance(String label) {
    return new EventsNode(label);
  }

  /**
   * Selects the global actor identified by the name.
   *
   * @param name	the name of the global actor
   */
  public EventsNode findEvent(String name) {
    EventsNode	result;
    BaseTreeNode	node;
    Enumeration		enm;
    EventsNode	child;

    result = null;

    if ((name != null) && (name.length() > 0)) {
      node = (BaseTreeNode) getTreeModel().getRoot();
      if (node != null) {
	enm = node.breadthFirstEnumeration();
	while (enm.hasMoreElements()) {
	  node = (BaseTreeNode) enm.nextElement();
	  if (node instanceof EventsNode) {
	    child = (EventsNode) node;
	    if (child.isEvent() && child.getLabel().equals(name)) {
	      result = child;
	      break;
	    }
	  }
	}
      }
    }

    return result;
  }

  /**
   * Selects the global actor identified by the name.
   *
   * @param name	the name of the global actor
   */
  public void selectEvent(String name) {
    EventsNode	node;
    TreePath		path;

    node = findEvent(name);
    if (node != null) {
      path = new TreePath(node.getPath());
      setSelectionPath(path);
    }
  }
}
