/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionConsumerTestCase;
import adams.core.option.JsonConsumer;
import adams.core.option.OptionHandler;
import adams.data.baseline.AbstractBaselineCorrection;
import adams.data.baseline.SlidingWindow;
import adams.data.conversion.AbstractConversion;
import adams.data.conversion.StringToDouble;
import adams.data.filter.AbstractFilter;
import adams.data.filter.BaselineCorrection;
import adams.data.filter.MultiFilter;
import adams.data.filter.PassThrough;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.StringConstants;
import adams.flow.transformer.Convert;
import adams.flow.transformer.MathExpression;
import adams.parser.MathematicalExpressionText;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class JsonConsumerTest
extends AbstractOptionConsumerTestCase<JSONObject> {
    public JsonConsumerTest(String name) {
        super(name);
    }

    public void testConsumeSimple() {
        DumpFile handler = new DumpFile();
        handler.setDebugLevel(1);
        handler.setOutputFile(new PlaceholderFile("${TMP}/dumpfile.csv"));
        handler.setAppend(true);
        JSONObject input = new JSONObject();
        input.put((Object)"class", (Object)"adams.flow.sink.DumpFile");
        input.put((Object)"debugLevel", (Object)1);
        input.put((Object)"outputFile", (Object)"${TMP}/dumpfile.csv");
        input.put((Object)"append", (Object)true);
        this.performInputTest((AbstractOptionConsumer)new JsonConsumer(), input, (OptionHandler)handler);
    }

    public void testFromStringSimple() {
        DumpFile handler = new DumpFile();
        handler.setDebugLevel(1);
        handler.setOutputFile(new PlaceholderFile("${TMP}/dumpfile.csv"));
        handler.setAppend(true);
        JSONObject input = new JSONObject();
        input.put((Object)"class", (Object)"adams.flow.sink.DumpFile");
        input.put((Object)"debugLevel", (Object)1);
        input.put((Object)"outputFile", (Object)"${TMP}/dumpfile.csv");
        input.put((Object)"append", (Object)true);
        this.performFromStringTest(JsonConsumer.class, input.toJSONString(), (OptionHandler)handler);
    }

    public void testConsumeDeep() {
        MultiFilter handler = new MultiFilter();
        handler.setDebugLevel(1);
        AbstractFilter[] filters = new AbstractFilter[2];
        filters[0] = new PassThrough();
        filters[0].setDebugLevel(2);
        filters[1] = new MultiFilter();
        filters[1].setDebugLevel(3);
        handler.setSubFilters(filters);
        JSONObject input = new JSONObject();
        input.put((Object)"class", (Object)"adams.data.filter.MultiFilter");
        JSONArray options = new JSONArray();
        input.put((Object)"subFilters", (Object)options);
        input.put((Object)"debugLevel", (Object)1);
        JSONObject filter1 = new JSONObject();
        options.add((Object)filter1);
        filter1.put((Object)"class", (Object)"adams.data.filter.PassThrough");
        filter1.put((Object)"debugLevel", (Object)2);
        JSONObject filter2 = new JSONObject();
        options.add((Object)filter2);
        filter2.put((Object)"class", (Object)"adams.data.filter.MultiFilter");
        filter2.put((Object)"debugLevel", (Object)3);
        JSONArray options2 = new JSONArray();
        filter2.put((Object)"subFilters", (Object)options2);
        JSONObject filter3 = new JSONObject();
        options2.add((Object)filter3);
        filter3.put((Object)"class", (Object)"adams.data.filter.PassThrough");
        this.performInputTest((AbstractOptionConsumer)new JsonConsumer(), input, (OptionHandler)handler);
    }

    public void testFromStringDeep() {
        MultiFilter handler = new MultiFilter();
        handler.setDebugLevel(1);
        AbstractFilter[] filters = new AbstractFilter[2];
        filters[0] = new PassThrough();
        filters[0].setDebugLevel(2);
        filters[1] = new MultiFilter();
        filters[1].setDebugLevel(3);
        handler.setSubFilters(filters);
        JSONObject input = new JSONObject();
        input.put((Object)"class", (Object)"adams.data.filter.MultiFilter");
        JSONArray options = new JSONArray();
        input.put((Object)"subFilters", (Object)options);
        input.put((Object)"debugLevel", (Object)1);
        JSONObject filter1 = new JSONObject();
        options.add((Object)filter1);
        filter1.put((Object)"class", (Object)"adams.data.filter.PassThrough");
        filter1.put((Object)"debugLevel", (Object)2);
        JSONObject filter2 = new JSONObject();
        options.add((Object)filter2);
        filter2.put((Object)"class", (Object)"adams.data.filter.MultiFilter");
        filter2.put((Object)"debugLevel", (Object)3);
        JSONArray options2 = new JSONArray();
        filter2.put((Object)"subFilters", (Object)options2);
        JSONObject filter3 = new JSONObject();
        options2.add((Object)filter3);
        filter3.put((Object)"class", (Object)"adams.data.filter.PassThrough");
        this.performFromStringTest(JsonConsumer.class, input.toJSONString(), (OptionHandler)handler);
    }

    public void testConsumeDeep2() {
        BaselineCorrection handler = new BaselineCorrection();
        SlidingWindow baselineObj = new SlidingWindow();
        baselineObj.setDebugLevel(2);
        handler.setBaselineCorrection((AbstractBaselineCorrection)baselineObj);
        JSONObject input = new JSONObject();
        input.put((Object)"class", (Object)"adams.data.filter.BaselineCorrection");
        JSONObject input2 = new JSONObject();
        input.put((Object)"baselineCorrection", (Object)input2);
        input2.put((Object)"class", (Object)"adams.data.baseline.SlidingWindow");
        input2.put((Object)"debugLevel", (Object)2);
        JSONObject input3 = new JSONObject();
        input2.put((Object)"baselineCorrection", (Object)input3);
        input3.put((Object)"class", (Object)"adams.data.baseline.PassThrough");
        this.performInputTest((AbstractOptionConsumer)new JsonConsumer(), input, (OptionHandler)handler);
    }

    public void testFromStringDeep2() {
        BaselineCorrection handler = new BaselineCorrection();
        SlidingWindow baseline = new SlidingWindow();
        baseline.setDebugLevel(2);
        handler.setBaselineCorrection((AbstractBaselineCorrection)baseline);
        JSONObject input = new JSONObject();
        input.put((Object)"class", (Object)"adams.data.filter.BaselineCorrection");
        JSONObject input2 = new JSONObject();
        input.put((Object)"baselineCorrection", (Object)input2);
        input2.put((Object)"class", (Object)"adams.data.baseline.SlidingWindow");
        input2.put((Object)"debugLevel", (Object)2);
        JSONObject input3 = new JSONObject();
        input2.put((Object)"baselineCorrection", (Object)input3);
        input3.put((Object)"class", (Object)"adams.data.baseline.PassThrough");
        this.performFromStringTest(JsonConsumer.class, input.toJSONString(), (OptionHandler)handler);
    }

    public void testFromStringDeep3() {
        Flow handler = new Flow();
        StringConstants sc = new StringConstants();
        sc.setStrings(new BaseString[]{new BaseString("1"), new BaseString("2"), new BaseString("3")});
        StringToDouble s2d = new StringToDouble();
        Convert con = new Convert();
        con.setConversion((AbstractConversion)s2d);
        MathExpression me = new MathExpression();
        me.setExpression(new MathematicalExpressionText("X^2"));
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile(new PlaceholderFile("${TMP}/dumpfile.txt"));
        handler.setActors(new AbstractActor[]{sc, con, me, df});
        JSONObject input = new JSONObject();
        input.put((Object)"class", (Object)"adams.flow.control.Flow");
        JSONArray actors = new JSONArray();
        input.put((Object)"actors", (Object)actors);
        JSONObject input2 = new JSONObject();
        actors.add((Object)input2);
        input2.put((Object)"class", (Object)"adams.flow.source.StringConstants");
        JSONArray strings = new JSONArray();
        strings.add((Object)"1");
        strings.add((Object)"2");
        strings.add((Object)"3");
        input2.put((Object)"strings", (Object)strings);
        JSONObject input3 = new JSONObject();
        actors.add((Object)input3);
        input3.put((Object)"class", (Object)"adams.flow.transformer.Convert");
        JSONObject input4 = new JSONObject();
        input4.put((Object)"class", (Object)"adams.data.conversion.StringToDouble");
        input3.put((Object)"conversion", (Object)input4);
        JSONObject input5 = new JSONObject();
        actors.add((Object)input5);
        input5.put((Object)"class", (Object)"adams.flow.transformer.MathExpression");
        input5.put((Object)"expression", (Object)"X^2");
        JSONObject input6 = new JSONObject();
        actors.add((Object)input6);
        input6.put((Object)"class", (Object)"adams.flow.sink.DumpFile");
        input6.put((Object)"append", (Object)true);
        input6.put((Object)"outputFile", (Object)"${TMP}/dumpfile.txt");
        this.performFromStringTest(JsonConsumer.class, input.toJSONString(), (OptionHandler)handler);
    }
}

