/*
 * Decompiled with CFR 0.152.
 */
package adams.test;

import adams.core.ClassLocator;
import adams.core.Utils;
import adams.core.management.ProcessUtils;
import adams.core.option.OptionHandler;
import adams.env.Environment;
import adams.gui.scripting.ScriptingEngine;
import adams.test.AbstractTestHelper;
import adams.test.Regression;
import adams.test.TestHelper;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class AdamsTestCase
extends TestCase {
    public static final String PROPERTY_MULTIPROCESS_ENABLED = "adams.test.multiprocess.enabled";
    public static final String PROPERTY_ENV_CLASS = "adams.env.class";
    protected static boolean m_MultiProcessInfoOutput;
    protected Regression m_Regression;
    protected AbstractTestHelper m_TestHelper;
    protected boolean m_MultiProcessEnabled;

    public AdamsTestCase(String name) {
        super(name);
    }

    protected Class getTestedClass() {
        Class<?> result = null;
        if (((Object)((Object)this)).getClass().getName().endsWith("Test")) {
            try {
                result = Class.forName(((Object)((Object)this)).getClass().getName().replaceAll("Test$", ""));
            }
            catch (Exception e) {
                result = null;
            }
        }
        return result;
    }

    protected void setUp() throws Exception {
        super.setUp();
        String clsname = System.getProperty(PROPERTY_ENV_CLASS, Environment.class.getName());
        Environment.setEnvironmentClass(Class.forName(clsname));
        Class cls = this.getTestedClass();
        if (cls != null) {
            this.m_Regression = new Regression(cls);
        }
        this.m_TestHelper = this.newTestHelper();
        this.m_MultiProcessEnabled = Boolean.getBoolean(PROPERTY_MULTIPROCESS_ENABLED);
        if (!this.m_MultiProcessEnabled && !m_MultiProcessInfoOutput) {
            m_MultiProcessInfoOutput = true;
            System.err.println("Multi-process tests (if any) not enabled.\nYou can enable them using the following JVM parameter:\n  -Dadams.test.multiprocess.enabled=true\nNote: these tests could extend the running time of the tests considerably!");
        }
    }

    protected void tearDown() throws Exception {
        this.m_Regression = null;
        ScriptingEngine.stopAllEngines();
        super.tearDown();
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper(this, "");
    }

    protected void performSerializableTest(Class cls) {
        if (!ClassLocator.hasInterface(Serializable.class, (Class)cls)) {
            return;
        }
        Constructor constr = null;
        try {
            constr = cls.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            AdamsTestCase.fail((String)("No default constructor, requires custom test method: " + cls.getName()));
        }
        Object obj = null;
        try {
            obj = constr.newInstance(new Object[0]);
        }
        catch (Exception e) {
            AdamsTestCase.fail((String)("Failed to instantiate object using default constructor: " + cls.getName()));
        }
        AdamsTestCase.assertNotNull((String)"Serialization failed", (Object)Utils.deepCopy(obj));
    }

    public void testSerializable() {
        if (this.m_Regression != null) {
            this.performSerializableTest(this.m_Regression.getRegressionClass());
        }
    }

    protected void performDefaultOptionsTest(Class cls) {
        if (!ClassLocator.hasInterface(OptionHandler.class, (Class)cls)) {
            return;
        }
        Constructor constr = null;
        try {
            constr = cls.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            AdamsTestCase.fail((String)("No default constructor, requires custom test method: " + cls.getName()));
        }
        Object obj = null;
        try {
            obj = constr.newInstance(new Object[0]);
        }
        catch (Exception e) {
            AdamsTestCase.fail((String)("Failed to instantiate object using default constructor: " + cls.getName()));
        }
        OptionHandler handler = obj;
        handler.getOptionManager().setThrowExceptions(true);
        try {
            handler.getOptionManager().setDefaults();
        }
        catch (Exception e) {
            AdamsTestCase.fail((String)("Setting default options failed: " + cls.getName()));
        }
    }

    public void testDefaultOptions() {
        if (this.m_Regression != null) {
            this.performDefaultOptionsTest(this.m_Regression.getRegressionClass());
        }
    }

    public static void runTest(Test suite) {
        System.out.println("PID: " + ProcessUtils.getVirtualMachinePID());
        TestRunner.run((Test)suite);
    }
}

