/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Constants.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.core;

import java.io.Serializable;

/**
 * Contains some commonly used constants.
 *
 * @author  peter (peter at waikato dot ac dot nz)
 * @version $Revision: 4584 $
 */
public class Constants
  implements Serializable {

  /** for serialization. */
  private static final long serialVersionUID = 6844330611108433085L;

  /** the unitialized ID. */
  public final static int NO_ID = -1;

  /** the dummy ID. */
  public final static String DUMMY_ID = "dummy";

  /** the date format for timestamps. */
  public final static String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";

  /** the date format for timestamps (ISO-8601). */
  public final static String TIMESTAMP_FORMAT_ISO8601 = "yyyy-MM-dd'T'HH:mm:ss";

  /** the character to use for "hiding" the password characters. */
  public final static char PASSWORD_CHAR = '*';
}
