/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * AbstractComplexElement.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.doc.docbook;

/**
 * Ancestor for elements that have nested elements.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4584 $
 */
public abstract class AbstractComplexElement
  extends AbstractElement {

  /** for serialization. */
  private static final long serialVersionUID = -43542338015882364L;

  /**
   * Initializes the element.
   *
   * @param tag		the name of the tag
   */
  public AbstractComplexElement(String tag) {
    super(tag);
  }

  /**
   * Appends the content of the element to the buffer.
   *
   * @param buffer	the buffer to append the content to
   */
  protected void appendContent(StringBuilder buffer) {
    int				i;
    AbstractElement	child;

    for (i = 0; i < getChildCount(); i++) {
      child = (AbstractElement) getChildAt(i);
      child.toXML(buffer);
    }
  }
}
