/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * DefaultSimpleElement.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.doc.docbook;

/**
 * A default simple element.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4584 $
 */
public class DefaultSimpleElement
  extends AbstractSimpleElement {

  /** for serialization. */
  private static final long serialVersionUID = -6126545140096452210L;

  /**
   * Initializes the element.
   *
   * @param tag		the name of the tag
   */
  public DefaultSimpleElement(String tag) {
    super(tag);
  }

  /**
   * Initializes the paragraph tag.
   *
   * @param tag		the name of the tag
   * @param content	the content of the tag
   */
  public DefaultSimpleElement(String tag, String content) {
    super(tag, content);
  }
}
