/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * AbstractTextDisplayPanel.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.sink;

/**
 * Ancestor for panels that can be created from tokens and supply the
 * underlying text.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4584 $
 */
public abstract class AbstractTextDisplayPanel
  extends AbstractDisplayPanel
  implements TextSupplier {

  /** for serialization. */
  private static final long serialVersionUID = 4636549254255374437L;

  /**
   * Initializes the panel.
   *
   * @param name	the name of the panel
   */
  public AbstractTextDisplayPanel(String name) {
    super(name);
  }

  /**
   * Supplies the text.
   *
   * @return		the text, null if none available
   */
  public abstract String supplyText();
}
