/*
 * Decompiled with CFR 0.152.
 */
package adams.data.random;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.io.FileUtils;
import adams.data.conversion.DoubleToString;
import adams.data.random.AbstractRandomNumberGenerator;
import adams.test.AdamsTestCase;
import adams.test.TmpFile;
import java.io.File;

public abstract class AbstractRandomNumberGeneratorTestCase
extends AdamsTestCase {
    public AbstractRandomNumberGeneratorTestCase(String name) {
        super(name);
    }

    protected int getNumGenerate() {
        return 20;
    }

    protected Number[] generate(AbstractRandomNumberGenerator scheme) {
        Number[] result = new Number[this.getNumGenerate()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = scheme.next();
        }
        return result;
    }

    protected boolean save(Number[] data, String filename) {
        String[] lines = new String[data.length];
        DoubleToString d2s = new DoubleToString();
        d2s.setNumDecimals(12);
        for (int i = 0; i < data.length; ++i) {
            d2s.setInput((Object)data[i].doubleValue());
            d2s.convert();
            lines[i] = d2s.getOutput().toString();
        }
        d2s.cleanUp();
        return FileUtils.saveToFile((String[])lines, (File)((Object)new TmpFile(filename)));
    }

    protected abstract AbstractRandomNumberGenerator[] getRegressionSetups();

    protected String createOutputFilename(int no) {
        return "randomnumbergenerator-out" + no;
    }

    public void testRegression() {
        int i;
        AbstractRandomNumberGenerator[] setups = this.getRegressionSetups();
        String[] output = new String[setups.length];
        for (i = 0; i < setups.length; ++i) {
            Number[] data = this.generate(setups[i]);
            AbstractRandomNumberGeneratorTestCase.assertNotNull((String)"Failed to generate data?", (Object)data);
            output[i] = this.createOutputFilename(i);
            boolean ok = this.save(data, output[i]);
            AbstractRandomNumberGeneratorTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles);
        AbstractRandomNumberGeneratorTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                ((CleanUpHandler)setups[i]).cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
    }

    protected void cleanUpAfterRegression() {
    }
}

