/*
 * Decompiled with CFR 0.152.
 */
package adams.data.statistics;

import adams.data.statistics.Percentile;
import adams.env.Environment;
import adams.test.AdamsTestCase;
import java.util.Random;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;

public class PercentileTest
extends AdamsTestCase {
    public PercentileTest(String name) {
        super(name);
    }

    public void testInteger() {
        Vector<Integer> values = new Vector<Integer>();
        for (int i = 1; i <= 100; ++i) {
            values.add(new Integer(i));
        }
        Percentile q = new Percentile();
        Random rand = new Random(1L);
        while (values.size() > 0) {
            int index = rand.nextInt(values.size());
            q.add((Comparable)values.get(index));
            values.remove(index);
        }
        Integer q1 = (Integer)q.getPercentile(0.25);
        Integer q3 = (Integer)q.getPercentile(0.75);
        PercentileTest.assertEquals((Object)new Integer(25), (Object)q1);
        PercentileTest.assertEquals((Object)new Integer(75), (Object)q3);
    }

    public void testDouble() {
        Vector<Double> values = new Vector<Double>();
        for (int i = 1; i <= 100; ++i) {
            values.add(new Double((double)i / 10.0));
        }
        Percentile q = new Percentile();
        Random rand = new Random(1L);
        while (values.size() > 0) {
            int index = rand.nextInt(values.size());
            q.add((Comparable)values.get(index));
            values.remove(index);
        }
        Double q1 = (Double)q.getPercentile(0.25);
        Double q3 = (Double)q.getPercentile(0.75);
        PercentileTest.assertEquals((Object)new Double(2.5), (Object)q1);
        PercentileTest.assertEquals((Object)new Double(7.5), (Object)q3);
    }

    public void testString() {
        Vector<String> values = new Vector<String>();
        for (int i = 1; i <= 100; ++i) {
            values.add(Integer.toString(1000 + i));
        }
        Percentile q = new Percentile();
        Random rand = new Random(1L);
        while (values.size() > 0) {
            int index = rand.nextInt(values.size());
            q.add((Comparable)values.get(index));
            values.remove(index);
        }
        String q1 = (String)((Object)q.getPercentile(0.25));
        String q3 = (String)((Object)q.getPercentile(0.75));
        PercentileTest.assertEquals((String)Integer.toString(1025), (String)q1);
        PercentileTest.assertEquals((String)Integer.toString(1075), (String)q3);
    }

    public static Test suite() {
        return new TestSuite(PercentileTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        PercentileTest.runTest(PercentileTest.suite());
    }
}

