/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.data.conversion.AbstractConversion;
import adams.data.conversion.IntToDouble;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.control.Sequence;
import adams.flow.control.Trigger;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.ForLoop;
import adams.flow.source.StringConstants;
import adams.flow.transformer.Convert;
import adams.flow.transformer.MathExpression;
import adams.parser.MathematicalExpressionText;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TriggerTest
extends AbstractFlowTest {
    public TriggerTest(String name) {
        super(name);
    }

    @Override
    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    @Override
    public AbstractActor getActor() {
        StringConstants sc = new StringConstants();
        sc.setStrings(new BaseString[]{new BaseString("1")});
        ForLoop fl1 = new ForLoop();
        fl1.setLoopLower(1);
        fl1.setLoopUpper(10);
        fl1.setLoopStep(1);
        IntToDouble i2d1 = new IntToDouble();
        Convert con1 = new Convert();
        con1.setConversion((AbstractConversion)i2d1);
        MathExpression me1 = new MathExpression();
        me1.setExpression(new MathematicalExpressionText("X"));
        DumpFile df1 = new DumpFile();
        df1.setAppend(true);
        df1.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Sequence seq1 = new Sequence();
        seq1.setActors(new AbstractActor[]{fl1, con1, me1, df1});
        Trigger trg1 = new Trigger();
        trg1.add(0, (AbstractActor)seq1);
        ForLoop fl2 = new ForLoop();
        fl2.setLoopLower(1);
        fl2.setLoopUpper(10);
        fl2.setLoopStep(1);
        IntToDouble i2d2 = new IntToDouble();
        Convert con2 = new Convert();
        con2.setConversion((AbstractConversion)i2d2);
        MathExpression me2 = new MathExpression();
        me2.setExpression(new MathematicalExpressionText("X^2"));
        DumpFile df2 = new DumpFile();
        df2.setAppend(true);
        df2.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Sequence seq2 = new Sequence();
        seq2.setActors(new AbstractActor[]{fl2, con2, me2, df2});
        Trigger trg2 = new Trigger();
        trg2.add(0, (AbstractActor)seq2);
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{sc, trg1, trg2});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest(new File[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(TriggerTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        TriggerTest.runTest(TriggerTest.suite());
    }
}

