/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.CustomDisplayStringProvider;
import adams.core.ExampleProvider;
import java.io.Serializable;

public class Index
implements Serializable,
CustomDisplayStringProvider,
Comparable<Index>,
ExampleProvider {
    private static final long serialVersionUID = 4295722716846349301L;
    public static final String FIRST = "first";
    public static final String SECOND = "second";
    public static final String THIRD = "third";
    public static final String LAST_1 = "last_1";
    public static final String LAST_2 = "last_2";
    public static final String LAST = "last";
    protected String m_Index;
    protected Integer m_IntIndex;
    protected int m_Max;

    public Index() {
        this("");
    }

    public Index(String index) {
        this(index, -1);
    }

    public Index(String index, int max) {
        this.setIndex(index);
        this.setMax(max);
    }

    public void setIndex(String value) {
        this.m_Index = this.clean(value);
        this.m_IntIndex = null;
    }

    public String getIndex() {
        return this.m_Index;
    }

    public void setMax(int value) {
        this.m_Max = value <= 0 ? -1 : value;
        this.m_IntIndex = null;
    }

    public int getMax() {
        return this.m_Max;
    }

    public boolean hasIndex() {
        return this.m_Index.length() > 0;
    }

    protected String clean(String s) {
        String result = "";
        String tmp = s.toLowerCase();
        if (tmp.equals(FIRST)) {
            result = tmp;
        } else if (tmp.equals(SECOND)) {
            result = tmp;
        } else if (tmp.equals(THIRD)) {
            result = tmp;
        } else if (tmp.equals(LAST_2)) {
            result = tmp;
        } else if (tmp.equals(LAST_1)) {
            result = tmp;
        } else if (tmp.equals(LAST)) {
            result = tmp;
        } else {
            try {
                int num = Integer.parseInt(tmp);
                if (num > 0) {
                    result = tmp;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    protected int parse(String s, int max) {
        int result = -1;
        if (max > -1) {
            if (s.equals(FIRST)) {
                result = 0;
            } else if (s.equals(SECOND)) {
                result = 1;
            } else if (s.equals(THIRD)) {
                result = 2;
            } else if (s.equals(LAST_2)) {
                result = max - 3;
            } else if (s.equals(LAST_1)) {
                result = max - 2;
            } else if (s.equals(LAST)) {
                result = max - 1;
            } else {
                try {
                    result = Integer.parseInt(s) - 1;
                }
                catch (Exception e) {
                    result = -1;
                }
            }
            if (result > max - 1 || result < 0) {
                result = -1;
            }
        } else {
            result = -1;
        }
        return result;
    }

    public int getIntIndex() {
        if (this.m_IntIndex == null) {
            this.m_IntIndex = this.parse(this.m_Index, this.m_Max);
        }
        return this.m_IntIndex;
    }

    @Override
    public int compareTo(Index o) {
        int result = this.getMax() != -1 && this.getMax() != -1 ? new Integer(this.getIntIndex()).compareTo(new Integer(o.getIntIndex())) : new Integer(this.parse(this.getIndex(), Integer.MAX_VALUE)).compareTo(new Integer(this.parse(o.getIndex(), Integer.MAX_VALUE)));
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Index)) {
            return false;
        }
        return this.compareTo((Index)obj) == 0;
    }

    public String toString() {
        return "index=" + this.m_Index + ", max=" + this.m_Max;
    }

    @Override
    public String toDisplay() {
        return this.getIndex();
    }

    @Override
    public String getExample() {
        return "An index is a number starting with 1; the following placeholders can be used as well: first, second, third, last_2, last_1, last";
    }
}

