/*
 * Decompiled with CFR 0.152.
 */
package adams.db;

import adams.core.base.BaseDateTime;
import adams.db.AbstractDatabaseConnection;
import adams.db.AbstractIndexedTable;
import adams.db.ColumnMapping;
import adams.db.LogEntry;
import adams.db.LogEntryConditions;
import adams.db.TableManager;
import adams.db.indices.Index;
import adams.db.indices.IndexColumn;
import adams.db.indices.Indices;
import adams.db.types.Auto_increment_type;
import adams.db.types.SQL_type;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Vector;

public class LogT
extends AbstractIndexedTable {
    private static final long serialVersionUID = -5955333734406125700L;
    public static final String TABLE_NAME = "logging";
    protected static TableManager<LogT> m_TableManager;

    private LogT(AbstractDatabaseConnection dbcon) {
        super(dbcon, TABLE_NAME);
    }

    @Override
    protected ColumnMapping getColumnMapping() {
        ColumnMapping result = new ColumnMapping();
        result.addMapping("AUTO_ID", new Auto_increment_type());
        result.addMapping("HOST", new SQL_type(12, 255));
        result.addMapping("IP", new SQL_type(12, 50));
        result.addMapping("TYPE", new SQL_type(12, 255));
        result.addMapping("MESSAGE", new SQL_type(-1));
        result.addMapping("GENERATION", new SQL_type(93));
        result.addMapping("SOURCE", new SQL_type(-1));
        result.addMapping("STATUS", new SQL_type(12, 255));
        return result;
    }

    @Override
    protected Indices getIndices() {
        Indices result = new Indices();
        Index index = new Index();
        index.add(new IndexColumn("AUTO_ID"));
        result.add(index);
        index = new Index();
        index.add(new IndexColumn("HOST"));
        result.add(index);
        index = new Index();
        index.add(new IndexColumn("IP"));
        result.add(index);
        index = new Index();
        index.add(new IndexColumn("TYPE"));
        result.add(index);
        index = new Index();
        index.add(new IndexColumn("GENERATION"));
        result.add(index);
        index = new Index();
        index.add(new IndexColumn("SOURCE", true, 255));
        result.add(index);
        index = new Index();
        index.add(new IndexColumn("STATUS"));
        result.add(index);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogEntry load(int auto_id) {
        LogEntry result = null;
        ResultSet rs = null;
        try {
            rs = this.select("*", "AUTO_ID = " + auto_id);
            result = this.resultsetToObject(rs);
            LogT.closeAll(rs);
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace(e);
        }
        finally {
            LogT.closeAll(rs);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<LogEntry> load(LogEntryConditions cond) {
        Vector<LogEntry> result = new Vector<LogEntry>();
        cond.update();
        Vector<String> where = new Vector<String>();
        if (!cond.getHost().isEmpty() && !cond.getHost().isMatchAll()) {
            where.add("HOST RLIKE " + LogT.backquote(cond.getHost()));
        }
        if (!cond.getIP().isEmpty() && !cond.getIP().isMatchAll()) {
            where.add("IP RLIKE " + LogT.backquote(cond.getIP()));
        }
        if (!cond.getType().isEmpty() && !cond.getType().isMatchAll()) {
            where.add("TYPE RLIKE " + LogT.backquote(cond.getType()));
        }
        if (!cond.getStatus().isEmpty() && !cond.getStatus().isMatchAll()) {
            where.add("STATUS RLIKE " + LogT.backquote(cond.getStatus()));
        }
        if (!cond.getSource().isEmpty() && !cond.getSource().isMatchAll()) {
            where.add("SOURCE RLIKE " + LogT.backquote(cond.getSource()));
        }
        if (!cond.getGenerationStartDate().equals(BaseDateTime.infinityPast())) {
            where.add("GENERATION >= '" + cond.getGenerationStartDate().stringValue() + "'");
        }
        if (!cond.getGenerationEndDate().equals(BaseDateTime.infinityFuture())) {
            where.add("GENERATION <= '" + cond.getGenerationEndDate().stringValue() + "'");
        }
        StringBuilder sqlWhere = new StringBuilder();
        for (int i = 0; i < where.size(); ++i) {
            if (i > 0) {
                sqlWhere.append(" AND ");
            }
            sqlWhere.append((String)where.get(i));
        }
        if (cond.getLatest()) {
            sqlWhere.append(" ORDER BY GENERATION DESC");
        } else {
            sqlWhere.append(" ORDER BY GENERATION ASC");
        }
        if (cond.getLimit() > -1) {
            sqlWhere.append(" LIMIT " + cond.getLimit());
        }
        ResultSet rs = null;
        try {
            LogEntry log;
            rs = this.select("*", sqlWhere.toString());
            while ((log = this.resultsetToObject(rs)) != null) {
                result.add(log);
            }
        }
        catch (Exception e) {
            try {
                this.getSystemErr().printStackTrace(e);
            }
            catch (Throwable throwable) {
                LogT.closeAll(rs);
                throw throwable;
            }
            LogT.closeAll(rs);
        }
        LogT.closeAll(rs);
        Collections.sort(result);
        return result;
    }

    protected LogEntry resultsetToObject(ResultSet rs) {
        LogEntry result = null;
        try {
            if (rs.next()) {
                result = new LogEntry();
                result.setDatabaseID(rs.getInt("AUTO_ID"));
                result.setHost(rs.getString("HOST"));
                result.setIP(rs.getString("IP"));
                result.setType(rs.getString("TYPE"));
                result.setMessage(rs.getString("MESSAGE"));
                result.setGeneration(rs.getTimestamp("GENERATION"));
                result.setSource(rs.getString("SOURCE"));
                result.setStatus(rs.getString("STATUS"));
            }
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace(e);
        }
        return result;
    }

    public boolean exists(LogEntry log) {
        return this.load(log.getDatabaseID()) != null;
    }

    protected boolean store(LogEntry log, boolean update) {
        String sql;
        boolean result = false;
        PreparedStatement stmt = null;
        if (update) {
            sql = "UPDATE " + this.getTableName() + " ";
            sql = sql + "SET HOST = ?, IP = ?, TYPE = ?, MESSAGE = ?, GENERATION = ?, SOURCE = ?, STATUS = ? ";
            sql = sql + "WHERE AUTO_ID = ?";
            try {
                stmt = this.prepareStatement(sql);
                stmt.setString(1, log.getHost());
                stmt.setString(2, log.getIP());
                stmt.setString(3, log.getType());
                stmt.setString(4, log.getMessageAsProperties().toString());
                stmt.setTimestamp(5, new Timestamp(log.getGeneration().getTime()));
                stmt.setString(6, log.getSource());
                stmt.setString(7, log.getStatus());
                stmt.setInt(8, log.getDatabaseID());
            }
            catch (Exception e) {
                this.getSystemErr().println("Failed to prepare update statement: " + sql);
                this.getSystemErr().printStackTrace(e);
                stmt = null;
            }
        } else {
            sql = "INSERT INTO " + this.getTableName() + "(HOST, IP, TYPE, MESSAGE, GENERATION, SOURCE, STATUS) ";
            sql = sql + "VALUES(?, ?, ?, ?, ?, ?, ?)";
            try {
                stmt = this.prepareStatement(sql);
                stmt.setString(1, log.getHost());
                stmt.setString(2, log.getIP());
                stmt.setString(3, log.getType());
                stmt.setString(4, log.getMessageAsProperties().toString());
                stmt.setTimestamp(5, new Timestamp(log.getGeneration().getTime()));
                stmt.setString(6, log.getSource());
                stmt.setString(7, log.getStatus());
            }
            catch (Exception e) {
                this.getSystemErr().println("Failed to prepare insert statement: " + sql);
                this.getSystemErr().printStackTrace(e);
                stmt = null;
            }
        }
        if (stmt != null) {
            try {
                this.debug("Executing prepared statement: " + sql);
                result = stmt.execute();
                this.debug("  --> result: " + result);
            }
            catch (Exception e) {
                this.getSystemErr().println("Storing failed using prepared statement: " + sql);
                this.getSystemErr().printStackTrace(e);
                result = false;
            }
        }
        return result;
    }

    public boolean add(LogEntry log) {
        if (this.exists(log)) {
            return true;
        }
        return this.store(log, false);
    }

    public boolean update(LogEntry log) {
        if (this.exists(log)) {
            return this.store(log, true);
        }
        return false;
    }

    public boolean remove(LogEntry log) {
        boolean result;
        String sql = "DELETE FROM " + this.getTableName() + " " + "WHERE AUTO_ID = " + log.getDatabaseID() + "";
        this.debug("Removing: " + sql);
        try {
            this.execute(sql);
            result = true;
        }
        catch (Exception e) {
            this.getSystemErr().println("Error removing: " + sql);
            this.getSystemErr().printStackTrace(e);
            result = false;
        }
        return result;
    }

    public static synchronized void initTable(AbstractDatabaseConnection dbcon) {
        LogT.getSingleton(dbcon).init();
    }

    public static synchronized LogT getSingleton(AbstractDatabaseConnection dbcon) {
        if (m_TableManager == null) {
            m_TableManager = new TableManager(TABLE_NAME, dbcon.getOwner());
        }
        if (!m_TableManager.has(dbcon)) {
            m_TableManager.add(dbcon, new LogT(dbcon));
        }
        return m_TableManager.get(dbcon);
    }
}

