/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.flow.control.SubProcess;
import adams.flow.core.AbstractActor;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import java.lang.reflect.Array;
import java.util.Hashtable;

public class ArrayProcess
extends SubProcess {
    private static final long serialVersionUID = 5975989766824652946L;
    public static final String BACKUP_OUTPUT = "output";
    protected String m_ArrayClass;
    protected Token m_OutputToken;

    @Override
    public String globalInfo() {
        return "Applies all sub-actors to each of the array elements.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("array-class", "arrayClass", "");
    }

    @Override
    public String getQuickInfo() {
        String result = "Class: ";
        String variable = this.getOptionManager().getVariableForProperty("arrayClass");
        result = variable != null ? result + variable : (this.m_ArrayClass.length() != 0 ? result + this.m_ArrayClass : result + "-from 1st element-");
        return result;
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_OutputToken = null;
    }

    public void setArrayClass(String value) {
        this.m_ArrayClass = value;
        this.reset();
    }

    public String getArrayClass() {
        return this.m_ArrayClass;
    }

    public String arrayClassTipText() {
        return "The class to use for the array; if none is specified, the class of the first element is used.";
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_OutputToken != null) {
            result.put(BACKUP_OUTPUT, this.m_OutputToken);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_OUTPUT)) {
            this.m_OutputToken = (Token)state.get(BACKUP_OUTPUT);
            state.remove(BACKUP_OUTPUT);
        }
        super.restoreState(state);
    }

    @Override
    public Class[] accepts() {
        if (this.active() > 0) {
            Class[] sub = ((InputConsumer)((Object)this.firstActive())).accepts();
            Class[] result = new Class[sub.length];
            for (int i = 0; i < sub.length; ++i) {
                result[i] = Array.newInstance(sub[i], 0).getClass();
            }
            return result;
        }
        return new Class[]{Unknown.class};
    }

    @Override
    public Class[] generates() {
        Class[] result;
        if (this.m_ArrayClass.length() > 0) {
            try {
                Class<?> cls = Class.forName(this.m_ArrayClass);
                result = new Class[]{Array.newInstance(cls, 0).getClass()};
            }
            catch (Exception e) {
                result = new Class[]{};
            }
        } else if (this.active() > 0) {
            Class[] sub = ((OutputProducer)((Object)this.lastActive())).generates();
            result = new Class[sub.length];
            for (int i = 0; i < sub.length; ++i) {
                result[i] = Array.newInstance(sub[i], 0).getClass();
            }
        } else {
            result = new Class[]{Unknown.class};
        }
        return result;
    }

    @Override
    public void input(Token token) {
        this.m_CurrentToken = token;
        this.m_OutputToken = null;
    }

    @Override
    protected String doExecute() {
        int i;
        String result = null;
        AbstractActor first = this.firstActive();
        if (this.isDebugOn()) {
            this.debug("first active actor: " + first.getFullName());
        }
        if (first != null && first instanceof InputConsumer) {
            int len = Array.getLength(this.m_CurrentToken.getPayload());
            for (i = 0; i < len; ++i) {
                Token input = new Token(Array.get(this.m_CurrentToken.getPayload(), i));
                ((InputConsumer)((Object)first)).input(input);
                if (this.getDebugLevel() > 1) {
                    this.debug("input token #" + (i + 1) + ": " + input, 2);
                }
                try {
                    result = this.m_Director.execute();
                }
                catch (Exception e) {
                    this.getSystemErr().printStackTrace(e);
                    result = e.toString();
                }
                if (result != null) break;
            }
        }
        if (!this.isStopped() && result == null && this.m_OutputTokens.size() > 0) {
            try {
                Object output = this.m_ArrayClass.length() == 0 ? Array.newInstance(((Token)this.m_OutputTokens.get(0)).getPayload().getClass(), this.m_OutputTokens.size()) : Array.newInstance(Class.forName(this.m_ArrayClass), this.m_OutputTokens.size());
                for (i = 0; i < this.m_OutputTokens.size(); ++i) {
                    Array.set(output, i, ((Token)this.m_OutputTokens.get(i)).getPayload());
                }
                this.m_OutputToken = new Token(output);
            }
            catch (Exception e) {
                result = "Failed to generate output array: " + e;
                this.m_OutputToken = null;
                this.getSystemErr().println(result);
                this.getSystemErr().printStackTrace(e);
            }
        }
        if (!this.isStopped()) {
            this.m_OutputTokens.clear();
        }
        return result;
    }

    @Override
    protected String postExecute() {
        String result = super.postExecute();
        if (this.isStopped()) {
            this.m_OutputToken = null;
        }
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_OutputToken != null;
    }

    @Override
    public Token output() {
        Token result = this.m_OutputToken;
        this.m_OutputToken = null;
        return result;
    }

    @Override
    public void wrapUp() {
        this.m_OutputToken = null;
        super.wrapUp();
    }
}

