/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.base.BaseString;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.flow.core.AutomatableInteractiveActor;
import adams.flow.core.InteractiveActor;
import adams.flow.source.AbstractArrayProvider;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.ExtensionFileFilter;
import java.io.File;

public class SelectFile
extends AbstractArrayProvider
implements InteractiveActor,
AutomatableInteractiveActor {
    private static final long serialVersionUID = 8200691218381875131L;
    protected String m_FileChooserTitle;
    protected PlaceholderDirectory m_InitialDirectory;
    protected BaseString[] m_Extensions;
    protected PlaceholderFile[] m_InitialFiles;
    protected boolean m_AbsoluteFileNames;
    protected boolean m_StopFlowIfCanceled;
    protected String m_CustomStopMessage;
    protected boolean m_NonInteractive;

    @Override
    public String globalInfo() {
        return "Pops up a file chooser dialog, prompting the user to select one or more files. The files then get forwarded as strings.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("stop-if-canceled", "stopFlowIfCanceled", false);
        this.m_OptionManager.add("custom-stop-message", "customStopMessage", "");
        this.m_OptionManager.add("file-chooser-title", "fileChooserTitle", "");
        this.m_OptionManager.add("initial-dir", "initialDirectory", new PlaceholderDirectory("."));
        this.m_OptionManager.add("extension", "extensions", new BaseString[0]);
        this.m_OptionManager.add("initial-file", "initialFiles", new PlaceholderFile[0]);
        this.m_OptionManager.add("absolute", "absoluteFileNames", false);
        this.m_OptionManager.add("non-interactive", "nonInteractive", false);
    }

    @Override
    public String getQuickInfo() {
        String result = "directory: ";
        String variable = this.getOptionManager().getVariableForProperty("initialDirectory");
        result = variable != null ? result + variable : result + this.m_InitialDirectory.toString();
        if (this.m_AbsoluteFileNames) {
            result = result + " (absolute file names)";
        }
        if (this.m_StopFlowIfCanceled) {
            result = result + " [stops flow if canceled]";
        }
        if (this.m_NonInteractive) {
            result = result + " -- non-interactive";
        }
        return result;
    }

    @Override
    public String outputArrayTipText() {
        return "Whether to output the files as array or one-by-one.";
    }

    public void setFileChooserTitle(String value) {
        this.m_FileChooserTitle = value;
        this.reset();
    }

    public String getFileChooserTitle() {
        return this.m_FileChooserTitle;
    }

    public String fileChooserTitleTipText() {
        return "The title for the file chooser dialog.";
    }

    public void setInitialDirectory(PlaceholderDirectory value) {
        this.m_InitialDirectory = value;
        this.reset();
    }

    public PlaceholderDirectory getInitialDirectory() {
        return this.m_InitialDirectory;
    }

    public String initialDirectoryTipText() {
        return "The initial directory for the file chooser.";
    }

    public void setExtensions(BaseString[] value) {
        this.m_Extensions = value;
        this.reset();
    }

    public BaseString[] getExtensions() {
        return this.m_Extensions;
    }

    public String extensionsTipText() {
        return "The extensions available through the file chooser.";
    }

    public void setInitialFiles(PlaceholderFile[] value) {
        this.m_InitialFiles = value;
        this.reset();
    }

    public PlaceholderFile[] getInitialFiles() {
        return this.m_InitialFiles;
    }

    public String initialFilesTipText() {
        return "The initial files for the file chooser.";
    }

    public void setAbsoluteFileNames(boolean value) {
        this.m_AbsoluteFileNames = value;
        this.reset();
    }

    public boolean getAbsoluteFileNames() {
        return this.m_AbsoluteFileNames;
    }

    public String absoluteFileNamesTipText() {
        return "If enabled, absolute file names instead of relative ones are output.";
    }

    @Override
    public void setStopFlowIfCanceled(boolean value) {
        this.m_StopFlowIfCanceled = value;
        this.reset();
    }

    @Override
    public boolean getStopFlowIfCanceled() {
        return this.m_StopFlowIfCanceled;
    }

    @Override
    public String stopFlowIfCanceledTipText() {
        return "If enabled, the flow gets stopped in case the user cancels the dialog.";
    }

    @Override
    public void setCustomStopMessage(String value) {
        this.m_CustomStopMessage = value;
        this.reset();
    }

    @Override
    public String getCustomStopMessage() {
        return this.m_CustomStopMessage;
    }

    @Override
    public String customStopMessageTipText() {
        return "The custom stop message to use in case a user cancelation stops the flow (default is the full name of the actor)";
    }

    @Override
    public void setNonInteractive(boolean value) {
        this.m_NonInteractive = value;
        this.reset();
    }

    @Override
    public boolean isNonInteractive() {
        return this.m_NonInteractive;
    }

    @Override
    public String nonInteractiveTipText() {
        return "If enabled, the initial value is forwarded without user interaction.";
    }

    @Override
    protected Class getItemClass() {
        return String.class;
    }

    @Override
    public boolean doInteract() {
        boolean result = false;
        this.m_Queue.clear();
        if (this.m_NonInteractive) {
            for (PlaceholderFile placeholderFile : this.m_InitialFiles) {
                if (this.m_AbsoluteFileNames) {
                    this.m_Queue.add(((File)placeholderFile).getAbsolutePath());
                    continue;
                }
                this.m_Queue.add(new PlaceholderFile(placeholderFile).toString());
            }
            return true;
        }
        BaseFileChooser fileChooser = new BaseFileChooser();
        fileChooser.resetChoosableFileFilters();
        for (BaseString baseString : this.m_Extensions) {
            ExtensionFileFilter filter = new ExtensionFileFilter(baseString.getValue().toUpperCase() + " files", baseString.getValue());
            fileChooser.addChoosableFileFilter(filter);
        }
        if (this.m_FileChooserTitle.length() > 0) {
            fileChooser.setDialogTitle(this.m_FileChooserTitle);
        }
        fileChooser.setCurrentDirectory(this.m_InitialDirectory);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setSelectedFiles(this.m_InitialFiles);
        int retVal = fileChooser.showOpenDialog(null);
        if (retVal == 0) {
            result = true;
            File[] files = fileChooser.getSelectedFiles();
            for (Comparable comparable : files) {
                if (this.m_AbsoluteFileNames) {
                    this.m_Queue.add(((File)comparable).getAbsolutePath());
                    continue;
                }
                this.m_Queue.add(new PlaceholderFile((File)comparable).toString());
            }
        }
        return result;
    }

    @Override
    protected String doExecute() {
        if (!this.isHeadless() && !this.doInteract() && this.m_StopFlowIfCanceled) {
            if (this.m_CustomStopMessage == null || this.m_CustomStopMessage.trim().length() == 0) {
                this.stopExecution("Flow canceled: " + this.getFullName());
            } else {
                this.stopExecution(this.m_CustomStopMessage);
            }
        }
        return this.m_StopMessage;
    }
}

