/*
 * RegionRecorder.java
 * Copyright (C) 2008 University of Waikato, Hamilton, New Zealand
 */

package adams.data;

import java.util.Vector;

import adams.data.container.DataContainer;

/**
 * A scheme that also records regions in the data.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 305 $
 * @param <T> the type of data that is recorded
 */
public interface RegionRecorder<T extends DataContainer> {

  /**
   * Sets whether the regions are recorded as well.
   *
   * @param value 	if true the regions will be recorded
   * @see		#getRegions()
   */
  public void setRecordRegions(boolean value);

  /**
   * Returns whether regions are recorded.
   *
   * @return 		true if the regions are recorded
   * @see		#getRegions()
   */
  public boolean getRecordRegions();

  /**
   * Returns the tip text for this property.
   *
   * @return 		tip text for this property suitable for
   * 			displaying in the GUI or for listing the options.
   */
  public String recordRegionsTipText();

  /**
   * Returns the regions that were recorded.
   *
   * @return		the regions
   */
  public Vector<T> getRegions();
}
