/**
 * InitialParameterGuesser.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.data.fit;

/**
 * Interface for functions that can guess the initial parameters based on
 * the input data.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2537 $
 */
public interface InitialParameterGuesser {

  /**
   * Returns the guessed parameters based on the input data.
   *
   * @param x		the x values
   * @param y		the y values
   * @return		the guesses for the initial parameters
   */
  public double[] guess(double[] x, double[] y);
}
