/**
 * FilteredDataProvider.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */
package adams.db;

import adams.data.container.DataContainer;

/**
 * Interface for data providers that normally returned the data filtered.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1505 $
 * @param <T> the type of container to use
 */
public interface FilteredDataProvider<T extends DataContainer>
  extends DataProvider<T> {

  /**
   * Load a data container with given auto_id, without passing it through
   * the global filter.
   *
   * @param auto_id	the databae ID
   * @return 		the data container, or null if not found
   */
  public T loadRaw(int auto_id);
}
