/*
 * ConnectionHandler.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.core;

/**
 * For actors that handle "sub-actors" that are connected.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4 $
 */
public interface ConnectionHandler {

  /**
   * Checks whether all the connections are valid, i.e., the input and
   * output types fit and whether the flow chain is connected properly.
   * 
   * @return		null if everything is fine, otherwise the offending
   * 			connection
   */
  public String checkConnections();
}
