/*
 * AboutBoxPanel.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.core;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.border.BevelBorder;

import adams.env.Modules;
import adams.env.Modules.Module;

/**
 * Represents an "About" box displayed from the main menu.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3403 $
 */
public class AboutBoxPanel
  extends BasePanel {

  /** for serialization. */
  private static final long serialVersionUID = -5180917605195603000L;

  /** the panel for the image. */
  protected JPanel m_PanelImage;

  /** the label displaying the image. */
  protected JLabel m_LabelImage;

  /** the panel for the title, copyright, etc. */
  protected JPanel m_PanelTitle;

  /** the panel with the modules. */
  protected JPanel m_PanelModules;

  /** the scroll pane for the modules. */
  protected BaseScrollPane m_ScrollPane;

  /**
   * Initializes the widgets.
   */
  protected void initGUI() {
    JPanel		panel;
    JPanel		panelModule;
    List<Module>	modules;
    JLabel		label;
    String		tiptext;

    super.initGUI();

    setLayout(new BorderLayout());

    m_PanelImage = new JPanel(new BorderLayout());
    m_LabelImage = new JLabel(GUIHelper.getLogoImage());
    m_PanelImage.add(m_LabelImage, BorderLayout.CENTER);
    add(m_PanelImage, BorderLayout.CENTER);

    panel = new JPanel(new BorderLayout());
    add(panel, BorderLayout.SOUTH);

    m_PanelTitle = new JPanel();
    m_PanelTitle.setLayout(new GridLayout(0, 1));
    m_PanelTitle.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
    panel.add(m_PanelTitle, BorderLayout.CENTER);

    modules = Modules.getSingleton().getModules();
    m_PanelModules = new JPanel(new FlowLayout(FlowLayout.LEFT));
    for (Module module: modules) {
      panelModule = new JPanel(new BorderLayout());
      panelModule.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
      tiptext = "";
      if (module.getDescription().length() > 0) {
	if (tiptext.length() > 0)
	  tiptext += "<br>\n";
	tiptext += module.getDescription();
      }
      if (module.getAuthor().length() > 0) {
	if (tiptext.length() > 0)
	  tiptext += "<br>\n";
	tiptext += module.getAuthor();
      }
      if (module.getOrganization().length() > 0) {
	if (tiptext.length() > 0)
	  tiptext += "<br>\n";
	tiptext += module.getOrganization();
      }
      label = new JLabel(module.getLogo());
      if (tiptext.length() > 0)
	label.setToolTipText("<html>" + tiptext + "</html>");
      panelModule.add(label, BorderLayout.CENTER);
      panelModule.add(new JLabel(module.getName(), SwingConstants.CENTER), BorderLayout.SOUTH);
      m_PanelModules.add(panelModule);
    }
    m_ScrollPane = new BaseScrollPane(m_PanelModules);
    m_ScrollPane.setPreferredSize(new Dimension(75, 100));
    panel.add(m_ScrollPane, BorderLayout.SOUTH);
  }

  /**
   * Sets the image to display.
   *
   * @param name	the name of the image
   */
  public void setImage(String name) {
    m_LabelImage.setIcon(GUIHelper.getIcon(name));
  }

  /**
   * Adds a label with the info.
   *
   * @param info	the information to display
   */
  public void addInfo(String info) {
    m_PanelTitle.add(new JLabel(info, SwingConstants.CENTER));
  }
}
