/*
 * FieldCacheUpdateEvent.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.event;

import java.util.EventObject;

import adams.gui.selection.AbstractFieldCacheItem;

/**
 * Event that gets sent when a field cache gets updated.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3507 $
 */
public class FieldCacheUpdateEvent
  extends EventObject {

  /** for serialization. */
  private static final long serialVersionUID = 8769821211266240856L;

  /**
   * Constructs the event.
   *
   * @param source	The cache item that triggered the event.
   */
  public FieldCacheUpdateEvent(AbstractFieldCacheItem source) {
    super(source);
  }

  /**
   * Returns the cache item that triggered the event.
   *
   * @return		the trigger
   */
  public AbstractFieldCacheItem getFieldCacheItem() {
    return (AbstractFieldCacheItem) getSource();
  }
}