/**
 * ContainerWithComponent.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.visualization.container;

import java.awt.Component;

/**
 * Interface for Containers that also store a Swing component associated with
 * the payload.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1604 $
 * @param <C> the type of component
 */
public interface ContainerWithComponent<C extends Component> {

  /**
   * Checks whether a component is stored.
   *
   * @return		true if a component is available
   */
  public boolean hasComponent();

  /**
   * Sets the component to associate.
   *
   * @param value	the component
   */
  public void setComponent(C value);

  /**
   * Returns the stored component.
   *
   * @return		the component, null if none available
   */
  public C getComponent();
}
