/*
 * DefaultContainerTableColumnNameGenerator.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.visualization.container;

/**
 * Abstract class for generating the column names of a table.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1604 $
 */
public class DefaultContainerTableColumnNameGenerator
  extends AbstractContainerTableColumnNameGenerator {

  /** for serialization. */
  private static final long serialVersionUID = 404785653515921294L;

  /**
   * Returns the name of the column with the visibility checkbox in it.
   *
   * @return		the name
   */
  public String getVisibility() {
    return "Vis.";
  }

  /**
   * Returns the width of the visibility column.
   *
   * @return		the width
   */
  public int getVisibilityWidth() {
    return 40;
  }

  /**
   * Returns the name of the column with the database ID in it.
   *
   * @return		the name
   */
  public String getDatabaseID() {
    return "DB-ID";
  }

  /**
   * Returns the width of the database ID column.
   *
   * @return		the width
   */
  public int getDatabaseIDWidth() {
    return 50;
  }

  /**
   * Returns the name of the column with the actual data in it.
   *
   * @return		the name
   */
  public String getData() {
    return "Item";
  }

  /**
   * Returns the width of the data column.
   *
   * @return		the width
   */
  public int getDataWidth() {
    return 80;
  }
}