/*
 * PopupMenuCustomizer.java
 * Copyright (C) 2008-2011 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.visualization.core;

import java.awt.event.MouseEvent;

import javax.swing.JPopupMenu;

/**
 * For classes that customize popup menus, before they're displayed.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4072 $
 */
public interface PopupMenuCustomizer {

  /**
   * Optional customizing of the menu that is about to be popped up.
   *
   * @param e		The mouse event
   * @param menu	The menu to customize, can be null if no menu items
   * 			have been added yet. Leave null if no popup to show.
   */
  public void customizePopupMenu(MouseEvent e, JPopupMenu menu);
}
