/*
 * DateTimeAxisModel.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.visualization.core.axis;

/**
 * An axis model for displaying date/time values.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3843 $
 */
public class DateTimeAxisModel
  extends AbstractDateBasedAxisModel {

  /** for serialization. */
  private static final long serialVersionUID = 6882846237550109166L;

  /**
   * Returns the display name of this model.
   *
   * @return		the display name
   */
  public String getDisplayName() {
    return "Date/time";
  }

  /**
   * Returns the default format for the date/time formatter.
   *
   * @return		the format string
   */
  protected String getDefaultDateFormat() {
    return "yy-MM-dd HH:mm";
  }
}