/**
 * PaintletWithFixedYRange.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.visualization.sequence;

/**
 * Interface for paintlets that use a fixed Y range.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2848 $
 */
public interface PaintletWithFixedYRange {

  /**
   * Returns the minimum to use for the Y range.
   *
   * @return		the minimum
   */
  public double getMinY();

  /**
   * Returns the maximum to use for the Y range.
   *
   * @return		the maximum
   */
  public double getMaxY();
}
