/*
 * FitnessFunction.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.optimise;

/**
 * Fitness function.
 * 
 * @author dale
 * @version $Revision: 1130 $
 */
public interface FitnessFunction {
  
  /**
   * Get fitness given vars. Higher the better.
   * 
   * @param opd	vars
   * @return	fitness
   */
  public double evaluate(OptData opd);
  
  /**
   * Callback. Do something with new best.
   * @param opd	data for new best
   */
  public void newBest(double ff,OptData opd);
}
