/*
 * InputFileHandler.java
 * Copyright (C) 2008 University of Waikato, Hamilton, New Zealand
 */

package adams.tools;

import adams.core.io.PlaceholderFile;

/**
 * For tools that handle an input file.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 25 $
 */
public interface InputFileHandler {

  /**
   * Set input file.
   * 
   * @param value	file
   */
  public void setInputFile(PlaceholderFile value);
  
  /**
   * Get input file.
   * 
   * @return	file
   */
  public PlaceholderFile getInputFile();
  
  /**
   * Returns the tip text for this property.
   * 
   * @return 		tip text for this property suitable for
   * 			displaying in the GUI or for listing the options.
   */
  public String inputFileTipText();
}
