/**
 * ArrayProducerTest.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.core.option;

import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.core.option.ArrayProducer;

/**
 * Tests the ArrayProducer class.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2822 $
 */
public class ArrayProducerTest
  extends AbstractOptionProducerTestCase {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public ArrayProducerTest(String name) {
    super(name);
  }

  /**
   * Tests a simple option handler.
   */
  public void testProduceSimple() {
    adams.flow.sink.DumpFile handler = new adams.flow.sink.DumpFile();
    handler.setDebugLevel(1);
    handler.setOutputFile(new PlaceholderFile("${TMP}/dumpfile.csv"));
    handler.setAppend(true);

    ArrayProducer producer = new ArrayProducer();
    producer.produce(handler);

    assertEquals(
	"getOutput() differs",
	"adams.flow.sink.DumpFile,-D,1,-output,${TMP}/dumpfile.csv,-append",
	Utils.arrayToString(producer.getOutput()));
    assertEquals(
	"toString() differs",
	"adams.flow.sink.DumpFile -D 1 -output ${TMP}/dumpfile.csv -append",
	producer.toString());
  }

  /**
   * Tests a deeply nested option handler.
   */
  public void testProduceDeep() {
    adams.data.filter.MultiFilter handler = new adams.data.filter.MultiFilter();
    handler.setDebugLevel(1);
    adams.data.filter.AbstractFilter[] filters = new adams.data.filter.AbstractFilter[2];
    filters[0] = new adams.data.filter.PassThrough();
    filters[0].setDebugLevel(2);
    filters[1] = new adams.data.filter.MultiFilter();
    filters[1].setDebugLevel(3);
    handler.setSubFilters(filters);

    ArrayProducer producer = new ArrayProducer();
    producer.produce(handler);

    assertEquals(
	"getOutput() differs",
	"adams.data.filter.MultiFilter,-D,1,-filter,adams.data.filter.PassThrough -D 2,-filter,adams.data.filter.MultiFilter -D 3 -filter adams.data.filter.PassThrough",
	Utils.arrayToString(producer.getOutput()));
    assertEquals(
	"toString() differs",
	"adams.data.filter.MultiFilter -D 1 -filter \"adams.data.filter.PassThrough -D 2\" -filter \"adams.data.filter.MultiFilter -D 3 -filter adams.data.filter.PassThrough\"",
	producer.toString());
  }

  /**
   * Tests another deeply nested option handler.
   */
  public void testProduceDeep2() {
    adams.data.filter.BaselineCorrection handler = new adams.data.filter.BaselineCorrection();
    adams.data.baseline.SlidingWindow baseline = new adams.data.baseline.SlidingWindow();
    baseline.setDebugLevel(2);
    handler.setBaselineCorrection(baseline);

    ArrayProducer producer = new ArrayProducer();
    producer.produce(handler);

    assertEquals(
	"getOutput() differs",
	"adams.data.filter.BaselineCorrection,-baseline,adams.data.baseline.SlidingWindow -D 2 -baseline adams.data.baseline.PassThrough",
	Utils.arrayToString(producer.getOutput()));
    assertEquals(
	"toString() differs",
	"adams.data.filter.BaselineCorrection -baseline \"adams.data.baseline.SlidingWindow -D 2 -baseline adams.data.baseline.PassThrough\"",
	producer.toString());
  }
}
