/**
 * FileToStringTest.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.data.conversion;

import adams.data.conversion.FileToString;
import adams.test.TmpFile;

import java.io.File;

/**
 * Tests the FileToString conversion.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2874 $
 */
public class FileToStringTest
  extends AbstractConversionTestCase {

  /**
   * Constructs the test case. Called by subclasses.
   *
   * @param name 	the name of the test
   */
  public FileToStringTest(String name) {
    super(name);
  }

  /**
   * Returns the input data to use in the regression test.
   *
   * @return		the objects
   */
  protected Object[] getRegressionInput() {
    return new File[]{
	new File("/home/sweet/home.txt"),
	new File("C:\\Microsoft is not the answer\\it is the question\\and the answer is no.odt"),
	new File("./some/place.txt")
    };
  }

  /**
   * Returns the setups to use in the regression test.
   *
   * @return		the setups
   */
  protected AbstractConversion[] getRegressionSetups() {
    FileToString[]	result;

    result = new FileToString[1];
    result[0] = new FileToString();
    // unfortunately, the "absolute paths" option will create regression files
    // that work only on the computer that they were generated on
    //result[1] = new FileToString();
    //result[1].setAbsolutePath(true);

    return result;
  }

  /**
   * Returns the ignored line indices to use in the regression test.
   *
   * @return		the setups
   */
  protected int[] getRegressionIgnoredLineIndices() {
    return new int[0];
  }
}
