/*
 * StoreReportValueInVariableTest.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.template;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.core.VariableName;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.env.Environment;
import adams.test.TmpFile;

/**
 * Tests the StoreReportValueInVariable template.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3916 $
 */
public class StoreReportValueInVariableTest
  extends AbstractActorTemplateTestCase {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public StoreReportValueInVariableTest(String name) {
    super(name);
  }

  /**
   * Returns the setups to use in the regression test.
   *
   * @return		the setups
   */
  protected AbstractActorTemplate[] getRegressionSetups() {
    StoreReportValueInVariable[]	result;

    result = new StoreReportValueInVariable[1];

    result[0] = new StoreReportValueInVariable();
    result[0].setVariableName(new VariableName("blah"));
    result[0].setField(new Field("blah", DataType.NUMERIC));

    return result;
  }

  /**
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(StoreReportValueInVariableTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
