/**
 * TmpFlowFile.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */
package adams.test;

import adams.core.io.FlowFile;

/**
 * A simple file handler class (for flow files) that automatically places the
 * file in the system's tmp directory. But the user still needs to delete the
 * file manually when it's no longer used.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1134 $
 */
public class TmpFlowFile
  extends FlowFile {

  /** for serialization. */
  private static final long serialVersionUID = 7689124528783850812L;

  /**
   * Creates a new <code>File</code> instance by converting the given
   * pathname string into an abstract pathname.  If the given string is
   * the empty string, then the result is the empty abstract pathname.
   *
   * @param   pathname  A pathname string
   */
  public TmpFlowFile(String pathname) {
    super(System.getProperty("java.io.tmpdir") + separator + pathname);
  }
}
