/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.option.AbstractArgumentOptionTest;
import adams.core.option.AbstractNumericOption;
import adams.core.option.AbstractOption;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNumericOptionTest<T>
extends AbstractArgumentOptionTest {
    protected T m_DefaultValueLower;
    protected T m_DefaultValueUpper;
    protected AbstractOption m_OptionLower;
    protected AbstractOption m_OptionUpper;

    public AbstractNumericOptionTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_OptionLower = this.getOption(this.getLowerBoundTestProperty());
        if (this.m_OptionLower == null) {
            throw new IllegalStateException("No option found for lower bound test!");
        }
        this.m_DefaultValueLower = this.getDefaultValue(this.getLowerBoundTestProperty());
        if (this.m_DefaultValueLower == null) {
            throw new IllegalStateException("No default value available for lower bound test!");
        }
        this.m_OptionUpper = this.getOption(this.getUpperBoundTestProperty());
        if (this.m_OptionUpper == null) {
            throw new IllegalStateException("No option found for upper bound test!");
        }
        this.m_DefaultValueUpper = this.getDefaultValue(this.getUpperBoundTestProperty());
        if (this.m_DefaultValueUpper == null) {
            throw new IllegalStateException("No default value available for upper bound test!");
        }
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.m_OptionLower = null;
        this.m_DefaultValueLower = null;
        this.m_OptionUpper = null;
        this.m_DefaultValueUpper = null;
    }

    protected abstract String getLowerBoundTestProperty();

    protected abstract T getLowerBoundTestValue();

    protected abstract String getUpperBoundTestProperty();

    protected abstract T getUpperBoundTestValue();

    protected AbstractOption getOption(String property) {
        return this.m_OptionHandler.getOptionManager().findByProperty(property);
    }

    protected T getDefaultValue(String property) {
        Object result = null;
        AbstractOption option = this.getOption(property);
        if (option != null) {
            result = option.getDefaultValue();
        }
        return (T)result;
    }

    public void testLowerBound() {
        String[] options = new String[]{"-" + this.m_OptionLower.getCommandline(), ((AbstractNumericOption)this.m_OptionLower).toString(this.getLowerBoundTestValue())};
        ArrayConsumer.setOptions((OptionHandler)this.m_OptionHandler, (String[])options);
        AbstractNumericOptionTest.assertEquals((String)"Out of bounds value (lower) did not result in default value", this.m_DefaultValueLower, (Object)this.m_OptionLower.getCurrentValue());
    }

    public void testUpperBound() {
        String[] options = new String[]{"-" + this.m_OptionUpper.getCommandline(), ((AbstractNumericOption)this.m_OptionUpper).toString(this.getUpperBoundTestValue())};
        ArrayConsumer.setOptions((OptionHandler)this.m_OptionHandler, (String[])options);
        AbstractNumericOptionTest.assertEquals((String)"Out of bounds value (upper) did not result in default value", this.m_DefaultValueUpper, (Object)this.m_OptionUpper.getCurrentValue());
    }
}

