/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionProducer;
import adams.core.option.OptionHandler;
import adams.data.baseline.AbstractBaselineCorrection;
import adams.data.baseline.SlidingWindow;
import adams.data.filter.AbstractFilter;
import adams.data.filter.BaselineCorrection;
import adams.data.filter.MultiFilter;
import adams.data.filter.PassThrough;
import adams.flow.sink.DumpFile;
import adams.test.AdamsTestCase;

public abstract class AbstractOptionProducerConsumerTestCase
extends AdamsTestCase {
    public AbstractOptionProducerConsumerTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected abstract AbstractOptionProducer getProducer();

    protected abstract AbstractOptionConsumer getConsumer();

    protected void performTest(OptionHandler handler, AbstractOptionProducer producer, AbstractOptionConsumer consumer) {
        producer.produce(handler);
        consumer.setInput(producer.getOutput());
        consumer.consume();
        OptionHandler created = consumer.getOutput();
        AbstractOptionProducerConsumerTestCase.assertEquals((String)"objects differ", (Object)handler, (Object)created);
        producer.cleanUp();
        consumer.cleanUp();
    }

    public void testProduceSimple() {
        DumpFile handler = new DumpFile();
        handler.setDebugLevel(1);
        handler.setOutputFile(new PlaceholderFile("${TMP}/dumpfile.csv"));
        handler.setAppend(true);
        this.performTest((OptionHandler)handler, this.getProducer(), this.getConsumer());
    }

    public void testProduceDeep() {
        MultiFilter handler = new MultiFilter();
        handler.setDebugLevel(1);
        AbstractFilter[] filters = new AbstractFilter[2];
        filters[0] = new PassThrough();
        filters[0].setDebugLevel(2);
        filters[1] = new MultiFilter();
        filters[1].setDebugLevel(3);
        handler.setSubFilters(filters);
        this.performTest((OptionHandler)handler, this.getProducer(), this.getConsumer());
    }

    public void testProduceDeep2() {
        BaselineCorrection handler = new BaselineCorrection();
        SlidingWindow baseline = new SlidingWindow();
        baseline.setDebugLevel(2);
        handler.setBaselineCorrection((AbstractBaselineCorrection)baseline);
        this.performTest((OptionHandler)handler, this.getProducer(), this.getConsumer());
    }

    public void testSerializable() {
        this.performSerializableTest(this.getProducer().getClass());
        this.performSerializableTest(this.getConsumer().getClass());
    }
}

