/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionConsumerTestCase;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionHandler;
import adams.data.baseline.AbstractBaselineCorrection;
import adams.data.baseline.SlidingWindow;
import adams.data.conversion.AbstractConversion;
import adams.data.conversion.StringToDouble;
import adams.data.filter.AbstractFilter;
import adams.data.filter.BaselineCorrection;
import adams.data.filter.MultiFilter;
import adams.data.filter.PassThrough;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.StringConstants;
import adams.flow.transformer.Convert;
import adams.flow.transformer.MathExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayConsumerTest
extends AbstractOptionConsumerTestCase<String[]> {
    public ArrayConsumerTest(String name) {
        super(name);
    }

    public void testConsumeSimple() {
        DumpFile handler = new DumpFile();
        handler.setDebugLevel(1);
        handler.setOutputFile(new PlaceholderFile("${TMP}/dumpfile.csv"));
        handler.setAppend(true);
        this.performInputTest((AbstractOptionConsumer)new ArrayConsumer(), new String[]{"adams.flow.sink.DumpFile", "-D", "1", "-output", "${TMP}/dumpfile.csv", "-append"}, (OptionHandler)handler);
    }

    public void testFromStringSimple() {
        DumpFile handler = new DumpFile();
        handler.setDebugLevel(1);
        handler.setOutputFile(new PlaceholderFile("${TMP}/dumpfile.csv"));
        handler.setAppend(true);
        this.performFromStringTest(ArrayConsumer.class, "adams.flow.sink.DumpFile -D 1 -output ${TMP}/dumpfile.csv -append", (OptionHandler)handler);
    }

    public void testConsumeDeep() {
        MultiFilter handler = new MultiFilter();
        handler.setDebugLevel(1);
        AbstractFilter[] filters = new AbstractFilter[2];
        filters[0] = new PassThrough();
        filters[0].setDebugLevel(2);
        filters[1] = new MultiFilter();
        filters[1].setDebugLevel(3);
        handler.setSubFilters(filters);
        this.performInputTest((AbstractOptionConsumer)new ArrayConsumer(), new String[]{"adams.data.filter.MultiFilter", "-D", "1", "-filter", "adams.data.filter.PassThrough -D 2", "-filter", "adams.data.filter.MultiFilter -D 3 -filter adams.data.filter.PassThrough"}, (OptionHandler)handler);
    }

    public void testFromStringDeep() {
        MultiFilter handler = new MultiFilter();
        handler.setDebugLevel(1);
        AbstractFilter[] filters = new AbstractFilter[2];
        filters[0] = new PassThrough();
        filters[0].setDebugLevel(2);
        filters[1] = new MultiFilter();
        filters[1].setDebugLevel(3);
        handler.setSubFilters(filters);
        this.performFromStringTest(ArrayConsumer.class, "adams.data.filter.MultiFilter -D 1 -filter \"adams.data.filter.PassThrough -D 2\" -filter \"adams.data.filter.MultiFilter -D 3 -filter adams.data.filter.PassThrough\"", (OptionHandler)handler);
    }

    public void testConsumeDeep2() {
        BaselineCorrection handler = new BaselineCorrection();
        SlidingWindow baseline = new SlidingWindow();
        baseline.setDebugLevel(2);
        handler.setBaselineCorrection((AbstractBaselineCorrection)baseline);
        this.performInputTest((AbstractOptionConsumer)new ArrayConsumer(), new String[]{"adams.data.filter.BaselineCorrection", "-baseline", "adams.data.baseline.SlidingWindow -D 2 -baseline adams.data.baseline.PassThrough"}, (OptionHandler)handler);
    }

    public void testFromStringDeep2() {
        BaselineCorrection handler = new BaselineCorrection();
        SlidingWindow baseline = new SlidingWindow();
        baseline.setDebugLevel(2);
        handler.setBaselineCorrection((AbstractBaselineCorrection)baseline);
        this.performFromStringTest(ArrayConsumer.class, "adams.data.filter.BaselineCorrection -baseline \"adams.data.baseline.SlidingWindow -D 2 -baseline adams.data.baseline.PassThrough\"", (OptionHandler)handler);
    }

    public void testFromStringDeep3() {
        Flow handler = new Flow();
        StringConstants sc = new StringConstants();
        sc.setStrings(new BaseString[]{new BaseString("1"), new BaseString("2"), new BaseString("3")});
        StringToDouble s2d = new StringToDouble();
        Convert con = new Convert();
        con.setConversion((AbstractConversion)s2d);
        MathExpression me = new MathExpression();
        me.setExpression("X^2");
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile(new PlaceholderFile("${TMP}/dumpfile.txt"));
        handler.setActors(new AbstractActor[]{sc, con, me, df});
        this.performFromStringTest(ArrayConsumer.class, "adams.flow.control.Flow -actor \"adams.flow.source.StringConstants -string 1 -string 2 -string 3\" -actor \"adams.flow.transformer.Convert -conversion adams.data.conversion.StringToDouble\" -actor \"adams.flow.transformer.MathExpression -expression X^2\" -actor \"adams.flow.sink.DumpFile -output ${TMP}/dumpfile.txt -append\"", (OptionHandler)handler);
    }
}

