/*
 * Decompiled with CFR 0.152.
 */
package adams.data;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.data.container.DataContainer;
import adams.test.AdamsTestCase;
import adams.test.TmpFile;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataGeneratorTestCase<A, D extends DataContainer>
extends AdamsTestCase {
    public AbstractDataGeneratorTestCase(String name) {
        super(name);
    }

    protected abstract D generate(A var1);

    protected boolean save(D data, String filename) {
        return this.m_TestHelper.save(data, filename);
    }

    protected abstract A[] getRegressionSetups();

    protected abstract int[] getRegressionIgnoredLineIndices();

    protected String createOutputFilename(int no) {
        return "datagenerator-out" + no;
    }

    public void testRegression() {
        int i;
        A[] setups = this.getRegressionSetups();
        int[] ignored = this.getRegressionIgnoredLineIndices();
        String[] output = new String[setups.length];
        for (i = 0; i < setups.length; ++i) {
            D data = this.generate(setups[i]);
            AbstractDataGeneratorTestCase.assertNotNull((String)"Failed to generate data?", data);
            output[i] = this.createOutputFilename(i);
            boolean ok = this.save(data, output[i]);
            AbstractDataGeneratorTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles, ignored);
        AbstractDataGeneratorTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                ((Destroyable)setups[i]).destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                ((CleanUpHandler)setups[i]).cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
    }

    protected void cleanUpAfterRegression() {
    }
}

