/*
 * Decompiled with CFR 0.152.
 */
package adams.flow;

import adams.env.Environment;
import adams.flow.setup.FlowSetup;
import adams.flow.setup.FlowSetupManager;
import adams.gui.scripting.ScriptingEngine;
import adams.test.AbstractFileStressTest;
import adams.test.AbstractStressTest;

public class StressTestControlSetup
extends AbstractFileStressTest {
    private static final long serialVersionUID = 4802926584425588665L;
    protected String m_Target;

    public String globalInfo() {
        return "Class for stress-testing flow control center setups.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("target", "target", (Object)"blah");
    }

    public void setTarget(String value) {
        this.m_Target = value;
        this.reset();
    }

    public String getTarget() {
        return this.m_Target;
    }

    public String targetTipText() {
        return "The target in the flow control center setup to execute.";
    }

    protected AbstractStressTest.Worker setupWorker(int iteration) {
        AbstractStressTest.Worker result = new AbstractStressTest.Worker(this, iteration){
            protected FlowSetupManager m_Manager;
            protected FlowSetup m_Setup;

            protected Object doInBackground() throws Exception {
                this.m_Manager = new FlowSetupManager();
                this.m_Manager.read(((AbstractFileStressTest)this.m_Owner).getFile().getAbsolutePath());
                int index = this.m_Manager.indexOf(((StressTestControlSetup)this.m_Owner).getTarget());
                this.m_Setup = (FlowSetup)this.m_Manager.get(index);
                this.m_Setup.execute(true);
                return null;
            }

            protected void done() {
                this.m_Setup.cleanUp();
                this.m_Setup = null;
                super.done();
            }

            public void stopExecution() {
                this.m_Setup.stopExecution();
            }
        };
        return result;
    }

    protected void postExecute() {
        ScriptingEngine.stopAllEngines();
    }

    public static void main(String[] args) {
        StressTestControlSetup.runStressTester(Environment.class, StressTestControlSetup.class, args);
    }
}

