/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.AbstractControlActor;
import adams.flow.control.Branch;
import adams.flow.control.Flow;
import adams.flow.control.Sequence;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.StringConstants;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class BranchTest
extends AbstractFlowTest {
    public BranchTest(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile1.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile2.txt");
        super.tearDown();
    }

    public AbstractActor getActor() {
        StringConstants ids = new StringConstants();
        ids.setStrings(new BaseString[]{new BaseString("1"), new BaseString("2"), new BaseString("3"), new BaseString("4"), new BaseString("5"), new BaseString("6"), new BaseString("7"), new BaseString("8"), new BaseString("9"), new BaseString("10"), new BaseString("11"), new BaseString("12"), new BaseString("13"), new BaseString("14"), new BaseString("15"), new BaseString("16"), new BaseString("17"), new BaseString("18"), new BaseString("19"), new BaseString("20"), new BaseString("21"), new BaseString("22"), new BaseString("23"), new BaseString("24"), new BaseString("25"), new BaseString("26"), new BaseString("27"), new BaseString("28"), new BaseString("29"), new BaseString("30")});
        DumpFile df1 = new DumpFile();
        df1.setAppend(true);
        df1.setOutputFile((PlaceholderFile)new TmpFile("dumpfile1.txt"));
        DumpFile df2 = new DumpFile();
        df2.setAppend(true);
        df2.setOutputFile((PlaceholderFile)new TmpFile("dumpfile2.txt"));
        Sequence seq1 = new Sequence();
        seq1.setActors(new AbstractActor[]{df1});
        Sequence seq2 = new Sequence();
        seq2.setActors(new AbstractActor[]{df2});
        Branch br = new Branch();
        br.setBranches((AbstractActor[])new AbstractControlActor[]{seq1, seq2});
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{ids, br});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest(new File[]{new TmpFile("dumpfile1.txt"), new TmpFile("dumpfile2.txt")});
    }

    public static Test suite() {
        return new TestSuite(BranchTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        BranchTest.runTest(BranchTest.suite());
    }
}

