/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.data.conversion.AbstractConversion;
import adams.data.conversion.StringToDouble;
import adams.data.conversion.StringToInt;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Branch;
import adams.flow.control.Flow;
import adams.flow.control.Sequence;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorReference;
import adams.flow.sink.DumpFile;
import adams.flow.sink.GlobalSink;
import adams.flow.source.StringConstants;
import adams.flow.standalone.GlobalActors;
import adams.flow.transformer.AnyToCommandline;
import adams.flow.transformer.Convert;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class AnyToCommandlineTest
extends AbstractFlowTest {
    public AnyToCommandlineTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public AbstractActor getActor() {
        DumpFile df = new DumpFile();
        df.setName("out");
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        GlobalActors ga = new GlobalActors();
        ga.setActors(new AbstractActor[]{df});
        StringConstants sc = new StringConstants();
        sc.setStrings(new BaseString[]{new BaseString("10"), new BaseString("1"), new BaseString("-10"), new BaseString("987")});
        StringToInt s2I = new StringToInt();
        Convert conI = new Convert();
        conI.setConversion((AbstractConversion)s2I);
        AnyToCommandline anyI = new AnyToCommandline();
        GlobalSink gsI = new GlobalSink();
        gsI.setGlobalName(new GlobalActorReference("out"));
        Sequence sI = new Sequence();
        sI.setActors(new AbstractActor[]{conI, anyI, gsI});
        StringToDouble s2D = new StringToDouble();
        Convert conD = new Convert();
        conD.setConversion((AbstractConversion)s2D);
        AnyToCommandline anyD = new AnyToCommandline();
        GlobalSink gsD = new GlobalSink();
        gsD.setGlobalName(new GlobalActorReference("out"));
        Sequence sD = new Sequence();
        sD.setActors(new AbstractActor[]{conD, anyD, gsD});
        Branch br = new Branch();
        br.setNumThreads(0);
        br.setBranches(new AbstractActor[]{sI, sD});
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{ga, sc, br});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)((Object)new TmpFile("dumpfile.txt")));
    }

    public static Test suite() {
        return new TestSuite(AnyToCommandlineTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        AnyToCommandlineTest.runTest(AnyToCommandlineTest.suite());
    }
}

