/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseString;
import adams.data.conversion.AbstractConversion;
import adams.data.conversion.StringToDouble;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.sink.Null;
import adams.flow.source.StringConstants;
import adams.flow.transformer.Convert;
import adams.flow.transformer.SequenceToArray;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SequenceToArrayTest
extends AbstractFlowTest {
    public SequenceToArrayTest(String name) {
        super(name);
    }

    public AbstractActor getActor() {
        StringConstants sc = new StringConstants();
        sc.setStrings(new BaseString[]{new BaseString("10.1"), new BaseString("1.3"), new BaseString("-10.9"), new BaseString("987.001")});
        StringToDouble s2d = new StringToDouble();
        Convert con = new Convert();
        con.setConversion((AbstractConversion)s2d);
        SequenceToArray s2a = new SequenceToArray();
        s2a.setArrayLength(4);
        SequenceToArray actor = new SequenceToArray();
        Null nul = new Null();
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{sc, con, s2a, actor, nul});
        return flow;
    }

    protected void performTest(Object[] objIn) {
        SequenceToArray actor = new SequenceToArray();
        actor.setArrayLength(objIn.length);
        SequenceToArrayTest.assertNull((String)"problem with setUp()", (Object)actor.setUp());
        for (int i = 0; i < objIn.length; ++i) {
            actor.input(new Token(objIn[i]));
            SequenceToArrayTest.assertNull((String)"problem with execute()", (Object)actor.execute());
        }
        Token out = actor.output();
        SequenceToArrayTest.assertNotNull((String)"problem with output()", (Object)out);
        Object[] array = (Object[])out.getPayload();
        for (int i = 0; i < objIn.length; ++i) {
            SequenceToArrayTest.assertEquals((String)("values at #" + i + " differ"), (Object)objIn[i], (Object)array[i]);
        }
        actor.wrapUp();
        actor.cleanUp();
    }

    public void testActorDouble() {
        Object[] in = new Double[]{123.0, 1.0, -3.0, 1001.0};
        for (int i = 0; i < in.length; ++i) {
            this.performTest(in);
        }
    }

    public void testActorInteger() {
        Object[] in = new Integer[]{123, 1, -3, 1001};
        for (int i = 0; i < in.length; ++i) {
            this.performTest(in);
        }
    }

    public void testActorString() {
        Object[] in = new String[]{"123", "1", "-3", "1001"};
        for (int i = 0; i < in.length; ++i) {
            this.performTest(in);
        }
    }

    public static Test suite() {
        return new TestSuite(SequenceToArrayTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SequenceToArrayTest.runTest(SequenceToArrayTest.suite());
    }
}

