/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * DatabaseConnections.java
 * Copyright (C) 2012 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.application;

import adams.gui.dialog.DatabaseConnectionsPanel;

/**
 * Initializes the database connections.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4584 $
 */
public class DatabaseConnections
  extends AbstractInitialization {

  /**
   * The title of the initialization.
   * 
   * @return		the title
   */
  public String getTitle() {
    return "Database connections";
  }
  
  /**
   * Performs the initialization.
   * 
   * @param parent	the application this initialization is for
   * @return		true if successful
   */
  public boolean initialize(final AbstractApplicationFrame parent) {
    new DatabaseConnectionsPanel();
    return true;
  }
}
