/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * ExternalActor.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.visualization.debug.inspectionhandler;

import java.util.Hashtable;

import adams.flow.core.AbstractExternalActor;

/**
 * Provides further insight into external actors.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4584 $
 */
public class ExternalActor
  extends AbstractInspectionHandler {

  /**
   * Checks whether the handler can handle the specified object.
   *
   * @param obj		the object to check
   * @return		true if the handler can handle this type of object
   */
  public boolean handles(Object obj) {
    return (obj instanceof AbstractExternalActor);
  }

  /**
   * Returns further inspection values.
   *
   * @param obj		the object to further inspect
   * @return		the named inspected values
   */
  public Hashtable<String,Object> inspect(Object obj) {
    Hashtable<String,Object>	result;
    Object			value;

    result = new Hashtable<String,Object>();

    value = ((AbstractExternalActor) obj).getExternalActor();
    if (value != null)
      result.put("external actor", value);

    return result;
  }
}
