/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * RemoveField.java
 * Copyright (C) 2012 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.visualization.report.reportfactory;

import java.awt.event.ActionEvent;

import adams.data.report.AbstractField;
import adams.data.report.Report;
import adams.db.ReportProvider;

/**
 * Removes the field from the report and updates the report in the database.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4705 $
 */
public class RemoveField
  extends AbstractTableActionWithDatabaseAccess {

  /** for serialization. */
  private static final long serialVersionUID = -7727702763234836816L;

  /**
   * Default constructor.
   */
  public RemoveField() {
    super("Remove field");
  }

  /**
   * Sets the field to use.
   * 
   * @param value	the field
   */
  protected void setField(AbstractField value) {
    super.setField(value);
    setName("Remove field '" + getField().toDisplayString() + "'");
  }

  /**
   * Invoked when an action occurs.
   * 
   * @param e		the event
   */
  public void actionPerformed(ActionEvent e) {
    ReportProvider 	provider;
    Report 		report;
    
    provider = getReportProvider();
    report   = getReport();
    report.removeValue(getField());
    provider.store(report.getDatabaseID(), report);
    setReport(report);
  }
}
