/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.option.ArrayProducer;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.baseline.AbstractBaselineCorrection;
import adams.data.baseline.SlidingWindow;
import adams.data.filter.AbstractFilter;
import adams.data.filter.BaselineCorrection;
import adams.env.Environment;
import adams.test.AdamsTestCase;
import java.util.Arrays;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;

public class OptionUtilsTest
extends AdamsTestCase {
    public OptionUtilsTest(String name) {
        super(name);
    }

    public void testCheckRemainingOptions() {
        String[] options = new String[]{};
        OptionUtilsTest.assertNull((String)"Should return null", (Object)OptionUtils.checkRemainingOptions((String[])options));
        options = new String[]{"-blah"};
        OptionUtilsTest.assertNotNull((String)"Should return an error message", (Object)OptionUtils.checkRemainingOptions((String[])options));
        options = new String[]{"", "\\", ""};
        OptionUtilsTest.assertNull((String)"Should return null", (Object)OptionUtils.checkRemainingOptions((String[])options));
    }

    public void testForCommandLine() throws Exception {
        String cmdline = "adams.data.filter.BaselineCorrection -baseline \"adams.data.baseline.SlidingWindow -D 2\"";
        BaselineCorrection filter = new BaselineCorrection();
        SlidingWindow baseline = new SlidingWindow();
        baseline.setDebugLevel(2);
        filter.setBaselineCorrection((AbstractBaselineCorrection)baseline);
        OptionHandler obj = OptionUtils.forCommandLine(AbstractFilter.class, (String)cmdline);
        OptionUtilsTest.assertEquals((String)"Class differs", filter.getClass(), obj.getClass());
        ArrayProducer prodFilter = new ArrayProducer();
        String[] optionsFilter = (String[])prodFilter.produce((OptionHandler)filter);
        ArrayProducer prodObj = new ArrayProducer();
        String[] optionsObj = (String[])prodObj.produce(obj);
        OptionUtilsTest.assertEquals((String)"options array differs in length", (int)optionsFilter.length, (int)optionsObj.length);
        for (int i = 0; i < optionsFilter.length; ++i) {
            OptionUtilsTest.assertEquals((String)("option #" + (i + 1) + " differs"), (String)optionsFilter[i], (String)optionsObj[i]);
        }
        prodFilter.cleanUp();
        prodObj.cleanUp();
    }

    public void testForName() throws Exception {
        String classname = "adams.data.filter.BaselineCorrection";
        String[] options = new String[]{"-baseline", "adams.data.baseline.SlidingWindow -D 2"};
        BaselineCorrection filter = new BaselineCorrection();
        SlidingWindow baseline = new SlidingWindow();
        baseline.setDebugLevel(2);
        filter.setBaselineCorrection((AbstractBaselineCorrection)baseline);
        Object obj = OptionUtils.forName(AbstractFilter.class, (String)classname, (String[])options);
        OptionUtilsTest.assertEquals((String)"Class differs", filter.getClass(), obj.getClass());
        ArrayProducer prodFilter = new ArrayProducer();
        String[] optionsFilter = (String[])prodFilter.produce((OptionHandler)filter);
        ArrayProducer prodObj = new ArrayProducer();
        String[] optionsObj = (String[])prodObj.produce((OptionHandler)obj);
        OptionUtilsTest.assertEquals((String)"options array differs in length", (int)optionsFilter.length, (int)optionsObj.length);
        for (int i = 0; i < optionsFilter.length; ++i) {
            OptionUtilsTest.assertEquals((String)("option #" + (i + 1) + " differs"), (String)optionsFilter[i], (String)optionsObj[i]);
        }
        prodFilter.cleanUp();
        prodObj.cleanUp();
    }

    public void testForString() throws Exception {
        BaselineCorrection filter = new BaselineCorrection();
        SlidingWindow baseline = new SlidingWindow();
        baseline.setDebugLevel(2);
        filter.setBaselineCorrection((AbstractBaselineCorrection)baseline);
        String str = "adams.data.filter.BaselineCorrection -baseline \"adams.data.baseline.SlidingWindow -D 2 -baseline adams.data.baseline.PassThrough\"";
        OptionUtilsTest.assertEquals((String)"objects differ (1)", (Object)filter, (Object)OptionUtils.forString(AbstractFilter.class, (String)str));
        str = "# some dummy comment\nadams.data.filter.BaselineCorrection\n\t-baseline\n\t\tadams.data.baseline.SlidingWindow\n\t\t\t-D\n\t\t\t2\n\t\t\t-baseline\n\t\t\t\tadams.data.baseline.PassThrough\n";
        OptionUtilsTest.assertEquals((String)"objects differ (2)", (Object)filter, (Object)OptionUtils.forString(AbstractFilter.class, (String)str));
    }

    public void testGetCommandLine() {
        String cmdline = "adams.data.filter.BaselineCorrection -baseline \"adams.data.baseline.SlidingWindow -D 2 -baseline adams.data.baseline.PassThrough\"";
        BaselineCorrection filter = new BaselineCorrection();
        SlidingWindow baseline = new SlidingWindow();
        baseline.setDebugLevel(2);
        filter.setBaselineCorrection((AbstractBaselineCorrection)baseline);
        OptionUtilsTest.assertEquals((String)"commandlines differ", (String)cmdline, (String)OptionUtils.getCommandLine((Object)filter));
    }

    public void testHelpRequested() {
        String[] options = new String[]{};
        OptionUtilsTest.assertFalse((String)"Shouldn't detect help", (boolean)OptionUtils.helpRequested((String[])options));
        OptionUtilsTest.assertFalse((String)"Shouldn't detect help", (boolean)OptionUtils.helpRequested(new Vector<String>(Arrays.asList(options))));
        options = new String[]{"-H"};
        OptionUtilsTest.assertFalse((String)"Shouldn't detect help", (boolean)OptionUtils.helpRequested((String[])options));
        OptionUtilsTest.assertFalse((String)"Shouldn't detect help", (boolean)OptionUtils.helpRequested(new Vector<String>(Arrays.asList(options))));
        options = new String[]{"-Help"};
        OptionUtilsTest.assertFalse((String)"Shouldn't detect help", (boolean)OptionUtils.helpRequested((String[])options));
        OptionUtilsTest.assertFalse((String)"Shouldn't detect help", (boolean)OptionUtils.helpRequested(new Vector<String>(Arrays.asList(options))));
        options = new String[]{"-h"};
        OptionUtilsTest.assertTrue((String)"Should have detected help", (boolean)OptionUtils.helpRequested((String[])options));
        OptionUtilsTest.assertTrue((String)"Should have detected help", (boolean)OptionUtils.helpRequested(new Vector<String>(Arrays.asList(options))));
        options = new String[]{"-help"};
        OptionUtilsTest.assertTrue((String)"Should have detected help", (boolean)OptionUtils.helpRequested((String[])options));
        OptionUtilsTest.assertTrue((String)"Should have detected help", (boolean)OptionUtils.helpRequested(new Vector<String>(Arrays.asList(options))));
        options = new String[]{"-blah", "hello", "-h"};
        OptionUtilsTest.assertTrue((String)"Should have detected help", (boolean)OptionUtils.helpRequested((String[])options));
        OptionUtilsTest.assertTrue((String)"Should have detected help", (boolean)OptionUtils.helpRequested(new Vector<String>(Arrays.asList(options))));
        options = new String[]{"-blah", "hello", "-help"};
        OptionUtilsTest.assertTrue((String)"Should have detected help", (boolean)OptionUtils.helpRequested((String[])options));
        OptionUtilsTest.assertTrue((String)"Should have detected help", (boolean)OptionUtils.helpRequested(new Vector<String>(Arrays.asList(options))));
        options = new String[]{"-blah", "hello", "-h", "-some", "3"};
        OptionUtilsTest.assertTrue((String)"Should have detected help", (boolean)OptionUtils.helpRequested((String[])options));
        OptionUtilsTest.assertTrue((String)"Should have detected help", (boolean)OptionUtils.helpRequested(new Vector<String>(Arrays.asList(options))));
        options = new String[]{"-blah", "hello", "-help", "-some", "3"};
        OptionUtilsTest.assertTrue((String)"Should have detected help", (boolean)OptionUtils.helpRequested((String[])options));
        OptionUtilsTest.assertTrue((String)"Should have detected help", (boolean)OptionUtils.helpRequested(new Vector<String>(Arrays.asList(options))));
        options = new String[]{"-h", "-some", "3"};
        OptionUtilsTest.assertTrue((String)"Should have detected help", (boolean)OptionUtils.helpRequested((String[])options));
        OptionUtilsTest.assertTrue((String)"Should have detected help", (boolean)OptionUtils.helpRequested(new Vector<String>(Arrays.asList(options))));
        options = new String[]{"-help", "-some", "3"};
        OptionUtilsTest.assertTrue((String)"Should have detected help", (boolean)OptionUtils.helpRequested((String[])options));
        OptionUtilsTest.assertTrue((String)"Should have detected help", (boolean)OptionUtils.helpRequested(new Vector<String>(Arrays.asList(options))));
    }

    public void testJoinOptions() {
        String[] options = new String[]{};
        OptionUtilsTest.assertEquals((String)"Should have length zero", (int)0, (int)OptionUtils.joinOptions((String[])options).length());
        options = new String[]{"-blah", "1"};
        OptionUtilsTest.assertEquals((String)"wrong joined length", (int)7, (int)OptionUtils.joinOptions((String[])options).length());
        options = new String[]{"-blah", "", "-some", "1"};
        OptionUtilsTest.assertEquals((String)"wrong joined length", (int)16, (int)OptionUtils.joinOptions((String[])options).length());
    }

    public void testSplitOptions() throws Exception {
        String cmdline = "-blah";
        OptionUtilsTest.assertEquals((String)"Wrong number of parsed elements", (int)1, (int)OptionUtils.splitOptions((String)cmdline).length);
        cmdline = "-blah 1";
        OptionUtilsTest.assertEquals((String)"Wrong number of parsed elements", (int)2, (int)OptionUtils.splitOptions((String)cmdline).length);
        cmdline = "-blah               1        -some 2";
        OptionUtilsTest.assertEquals((String)"Wrong number of parsed elements", (int)4, (int)OptionUtils.splitOptions((String)cmdline).length);
    }

    public void testShallowCopy() {
        BaselineCorrection corr = new BaselineCorrection();
        corr.setBaselineCorrection((AbstractBaselineCorrection)new SlidingWindow());
        OptionHandler copy = OptionUtils.shallowCopy((OptionHandler)corr, (boolean)false);
        OptionUtilsTest.assertNotNull((String)"shallow copy shouldn't be null", (Object)copy);
        OptionUtilsTest.assertEquals((String)"class differs", corr.getClass(), copy.getClass());
        ArrayProducer prodFilter = new ArrayProducer();
        String[] optionsFilter = (String[])prodFilter.produce((OptionHandler)corr);
        ArrayProducer prodObj = new ArrayProducer();
        String[] optionsObj = (String[])prodObj.produce(copy);
        OptionUtilsTest.assertEquals((String)"options array differs in length", (int)optionsFilter.length, (int)optionsObj.length);
        for (int i = 0; i < optionsFilter.length; ++i) {
            OptionUtilsTest.assertEquals((String)("option #" + (i + 1) + " differs"), (String)optionsFilter[i], (String)optionsObj[i]);
        }
        prodFilter.cleanUp();
        prodObj.cleanUp();
    }

    public void testHasFlag() {
        String[] optArray = new String[]{"-B", "-I", "6", "-R", "42"};
        OptionUtilsTest.assertFalse((boolean)OptionUtils.hasFlag((String[])optArray, (String)"-C"));
        OptionUtilsTest.assertTrue((boolean)OptionUtils.hasFlag((String[])optArray, (String)"-B"));
        OptionUtilsTest.assertTrue((boolean)OptionUtils.hasFlag((String[])optArray, (String)"-I"));
        Vector<String> optVector = new Vector<String>(Arrays.asList(optArray));
        OptionUtilsTest.assertFalse((boolean)OptionUtils.hasFlag(optVector, (String)"-C"));
        OptionUtilsTest.assertTrue((boolean)OptionUtils.hasFlag(optVector, (String)"-B"));
        OptionUtilsTest.assertTrue((boolean)OptionUtils.hasFlag(optVector, (String)"-I"));
    }

    public void testGetOption() {
        String[] optArray = new String[]{"-B", "-I", "6", "-R", "42"};
        OptionUtilsTest.assertNull((Object)OptionUtils.getOption((String[])optArray, (String)"-C"));
        OptionUtilsTest.assertEquals((String)"-I", (String)OptionUtils.getOption((String[])optArray, (String)"-B"));
        OptionUtilsTest.assertEquals((String)"6", (String)OptionUtils.getOption((String[])optArray, (String)"-I"));
        Vector<String> optVector = new Vector<String>(Arrays.asList(optArray));
        OptionUtilsTest.assertNull((Object)OptionUtils.getOption(optVector, (String)"-C"));
        OptionUtilsTest.assertEquals((String)"-I", (String)OptionUtils.getOption(optVector, (String)"-B"));
        OptionUtilsTest.assertEquals((String)"6", (String)OptionUtils.getOption(optVector, (String)"-I"));
    }

    public static Test suite() {
        return new TestSuite(OptionUtilsTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        OptionUtilsTest.runTest(OptionUtilsTest.suite());
    }
}

