/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.management.ProcessUtils;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.AbstractDataProcessorTestCase;
import adams.data.container.DataContainer;
import adams.data.filter.AbstractFilter;
import adams.test.AbstractTestHelper;
import adams.test.TestHelper;
import java.util.Vector;

public abstract class AbstractFilterTestCase<A extends AbstractFilter, D extends DataContainer>
extends AbstractDataProcessorTestCase<A, D, D> {
    public AbstractFilterTestCase(String name) {
        super(name);
    }

    @Override
    protected AbstractTestHelper newTestHelper() {
        return new TestHelper(this, "adams/data/filter/data");
    }

    @Override
    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    @Override
    protected D process(D data, A scheme) {
        return (D)scheme.filter(data);
    }

    public void testMultiProcess() {
        int i;
        if (!this.m_MultiProcessEnabled) {
            return;
        }
        int numFilters = ProcessUtils.getAvailableProcessors() + 1;
        String[] input = this.getRegressionInputFiles();
        AbstractFilter[] setups = (AbstractFilter[])this.getRegressionSetups();
        String[] props = this.getRegressionConnections();
        AbstractFilterTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        if (props != null) {
            AbstractFilterTestCase.assertEquals((String)"Number of files and connection setups differ!", (int)input.length, (int)props.length);
        } else {
            props = new String[input.length];
            for (i = 0; i < props.length; ++i) {
                props[i] = this.getDatabasePropertiesFile();
            }
        }
        for (i = 0; i < input.length; ++i) {
            int n;
            this.reconnect(props[i]);
            Object data = this.load(input[i]);
            AbstractFilterTestCase.assertNotNull((String)("Could not load data for regression test from " + input[i]), data);
            DataContainer backup = (DataContainer)data.getClone();
            Vector<AbstractFilter> current = new Vector<AbstractFilter>();
            for (n = 0; n < numFilters; ++n) {
                current.add((AbstractFilter)OptionUtils.shallowCopy((OptionHandler)setups[i], (boolean)false));
                AbstractFilterTestCase.assertNotNull((String)("Failed to create copy of algorithm: " + OptionUtils.getCommandLine((Object)setups[i])), current.get(n));
            }
            Vector processed = AbstractFilter.filter(current, data);
            AbstractFilterTestCase.assertNotNull((String)"Failed to process data?", (Object)processed);
            AbstractFilterTestCase.assertTrue((String)"Input got changed", (boolean)data.equals(backup));
            for (n = 1; n < numFilters; ++n) {
                AbstractFilterTestCase.assertTrue((String)("Output differs for #" + (n + 1)), (boolean)((DataContainer)processed.get(0)).equals(processed.get(n)));
            }
            if (!(setups[i] instanceof Destroyable)) continue;
            for (n = 0; n < numFilters; ++n) {
                ((Destroyable)current.get(n)).destroy();
            }
        }
        for (i = 0; i < setups.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
                continue;
            }
            if (!(setups[i] instanceof CleanUpHandler)) continue;
            setups[i].cleanUp();
        }
        this.m_Properties = null;
        this.getDatabaseProperties();
    }
}

