/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.env.Environment;
import adams.flow.control.Storage;
import adams.flow.control.StorageName;
import adams.test.AdamsTestCase;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;

public class StorageTest
extends AdamsTestCase {
    public StorageTest(String name) {
        super(name);
    }

    public void testClear() {
        Storage s = new Storage();
        s.put(new StorageName("blah"), (Object)1);
        StorageTest.assertEquals((String)"storage size > 0", (int)1, (int)s.size());
        s.clear();
        StorageTest.assertEquals((String)"storage size = 0", (int)0, (int)s.size());
    }

    public void testPutGetHasNoCache() {
        Storage s = new Storage();
        s.put(new StorageName("blah"), (Object)1);
        StorageTest.assertEquals((String)"storage size > 0", (int)1, (int)s.size());
        StorageTest.assertTrue((boolean)s.has(new StorageName("blah")));
        StorageTest.assertFalse((boolean)s.has(new StorageName("blah2")));
        StorageTest.assertEquals((String)"get", (Object)1, (Object)s.get(new StorageName("blah")));
        StorageTest.assertNull((String)"get", (Object)s.get(new StorageName("blah3")));
    }

    public void testPutGetHasCache() {
        int i;
        Storage s = new Storage();
        s.addCache("1", 10);
        s.put("1", new StorageName("blah"), (Object)1);
        StorageTest.assertEquals((String)"cache size > 0", (int)1, (int)s.size("1"));
        StorageTest.assertTrue((boolean)s.has("1", new StorageName("blah")));
        StorageTest.assertFalse((boolean)s.has("1", new StorageName("blah2")));
        StorageTest.assertEquals((String)"get", (Object)1, (Object)s.get("1", new StorageName("blah")));
        StorageTest.assertNull((String)"get", (Object)s.get("1", new StorageName("blah3")));
        for (i = 2; i < 8; ++i) {
            s.put("1", new StorageName("blah" + i), (Object)i);
        }
        StorageTest.assertEquals((String)"cache size", (int)7, (int)s.size("1"));
        StorageTest.assertTrue((boolean)s.has("1", new StorageName("blah")));
        for (i = 8; i < 15; ++i) {
            s.put("1", new StorageName("blah" + i), (Object)i);
        }
        StorageTest.assertEquals((String)"max cache size reaced", (int)10, (int)s.size("1"));
        StorageTest.assertFalse((boolean)s.has("1", new StorageName("blah")));
    }

    public void testRemoveNoCache() {
        Storage s = new Storage();
        s.put(new StorageName("blah"), (Object)1);
        s.put(new StorageName("blah2"), (Object)1);
        s.put(new StorageName("blah3"), (Object)1);
        StorageTest.assertEquals((String)"storage size", (int)3, (int)s.size());
        s.remove(new StorageName("blah4"));
        StorageTest.assertEquals((String)"removed non-existing item", (int)3, (int)s.size());
        s.remove(new StorageName("blah2"));
        StorageTest.assertEquals((String)"removed existing item", (int)2, (int)s.size());
    }

    public void testGetClone() {
        Storage s = new Storage();
        s.put(new StorageName("blah"), (Object)1);
        s.put(new StorageName("blah2"), (Object)1);
        s.put(new StorageName("blah3"), (Object)1);
        StorageTest.assertEquals((String)"storage size", (int)3, (int)s.size());
        s.addCache("1", 10);
        s.put("1", new StorageName("blah"), (Object)1);
        s.put("1", new StorageName("blah2"), (Object)1);
        s.put("1", new StorageName("blah3"), (Object)1);
        StorageTest.assertEquals((String)"storage size", (int)3, (int)s.size("1"));
        Storage sc = s.getClone();
        StorageTest.assertEquals((String)"storage size", (int)3, (int)sc.size());
        StorageTest.assertEquals((String)"storage size", (int)3, (int)sc.size("1"));
        Set keys = s.keySet();
        for (StorageName key : keys) {
            StorageTest.assertTrue((String)("key exists: " + key), (boolean)sc.has(key));
            StorageTest.assertEquals((String)("value the same: " + key), (Object)s.get(key), (Object)sc.get(key));
        }
        keys = s.keySet("1");
        for (StorageName key : keys) {
            StorageTest.assertTrue((String)("cache key exists: " + key), (boolean)sc.has("1", key));
            StorageTest.assertEquals((String)("cache value the same: " + key), (Object)s.get("1", key), (Object)sc.get("1", key));
        }
    }

    public void testRemoveCache() {
        Storage s = new Storage();
        s.addCache("1", 10);
        s.put("1", new StorageName("blah"), (Object)1);
        s.put("1", new StorageName("blah2"), (Object)1);
        s.put("1", new StorageName("blah3"), (Object)1);
        StorageTest.assertEquals((String)"storage size", (int)3, (int)s.size("1"));
        s.remove("1", new StorageName("blah4"));
        StorageTest.assertEquals((String)"removed non-existing item", (int)3, (int)s.size("1"));
        s.remove("1", new StorageName("blah2"));
        StorageTest.assertEquals((String)"removed existing item", (int)2, (int)s.size("1"));
    }

    public static Test suite() {
        return new TestSuite(StorageTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        StorageTest.runTest(StorageTest.suite());
    }
}

