/*
 * Decompiled with CFR 0.152.
 */
package adams.parser;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.Utils;
import adams.core.base.BaseString;
import adams.core.io.FileUtils;
import adams.parser.AbstractExpressionEvaluatorTestCase;
import adams.parser.AbstractSymbolEvaluator;
import adams.test.TmpFile;
import java.io.File;

public abstract class AbstractSymbolEvaluatorTestCase<D, E extends AbstractSymbolEvaluator>
extends AbstractExpressionEvaluatorTestCase<D, E> {
    public AbstractSymbolEvaluatorTestCase(String name) {
        super(name);
    }

    @Override
    protected Object[] process(String[] expressions, E scheme) {
        throw new IllegalStateException("Use 'process(String[],BaseString[][],E)' instead");
    }

    protected Object[] process(String[] expressions, BaseString[][] symbols, E scheme) {
        Object[] result = new Object[expressions.length];
        for (int i = 0; i < expressions.length; ++i) {
            scheme.setExpression(expressions[i]);
            scheme.setSymbols(symbols[i]);
            try {
                result[i] = scheme.evaluate();
                continue;
            }
            catch (Exception e) {
                result[i] = null;
            }
        }
        return result;
    }

    @Override
    protected boolean save(String[] expressions, Object[] data, String filename) {
        throw new IllegalStateException("Use 'save(String[],BaseString[][],Object[],String)' instead");
    }

    protected boolean save(String[] expressions, BaseString[][] symbols, Object[] data, String filename) {
        String[] content = new String[data.length];
        for (int i = 0; i < data.length; ++i) {
            content[i] = symbols[i].length > 0 ? "'" + expressions[i] + "' using " + Utils.arrayToString((Object)symbols[i]) + ": " + data[i] : "'" + expressions[i] + ": " + data[i];
        }
        return FileUtils.saveToFile((String[])content, (File)((Object)new TmpFile(filename)));
    }

    protected abstract BaseString[][][] getRegressionSymbols();

    @Override
    public void testRegression() {
        int i;
        String[][] expr = this.getRegressionExpressions();
        BaseString[][][] symbols = this.getRegressionSymbols();
        String[] output = new String[expr.length];
        AbstractSymbolEvaluator[] setups = (AbstractSymbolEvaluator[])this.getRegressionSetups();
        AbstractSymbolEvaluatorTestCase.assertEquals((String)"Number of expression arrays and setups differ!", (int)expr.length, (int)setups.length);
        AbstractSymbolEvaluatorTestCase.assertEquals((String)"Number of symbol arrays and setups differ!", (int)symbols.length, (int)setups.length);
        for (i = 0; i < expr.length; ++i) {
            Object[] processed = this.process(expr[i], symbols[i], setups[i]);
            AbstractSymbolEvaluatorTestCase.assertNotNull((String)"Failed to process data?", (Object)processed);
            output[i] = this.createOutputFilename(i);
            boolean ok = this.save(expr[i], symbols[i], processed, output[i]);
            AbstractSymbolEvaluatorTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles);
        AbstractSymbolEvaluatorTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                ((CleanUpHandler)setups[i]).cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
    }

    @Override
    protected void cleanUpAfterRegression() {
    }
}

