/*
 * Decompiled with CFR 0.152.
 */
package adams.db;

import adams.db.AbstractDatabaseConnection;
import adams.db.AbstractIndexedTable;
import adams.db.ColumnMapping;
import adams.db.MultipleInsert;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class BulkInsertTable
extends AbstractIndexedTable {
    private static final long serialVersionUID = 401732448232750879L;
    protected Vector<String> m_cols = new Vector();
    private boolean debug = false;

    public BulkInsertTable(AbstractDatabaseConnection dbcon, String tablename) {
        super(dbcon, tablename);
        ColumnMapping cm = this.getColumnMapping();
        Enumeration<String> enum1 = cm.keys();
        while (enum1.hasMoreElements()) {
            String cname = enum1.nextElement();
            this.m_cols.add(cname);
        }
    }

    public String generateInsertHeader() {
        return "INSERT INTO " + this.getTableName() + " (" + this.getInsertColumnsAsString() + ") VALUES ";
    }

    public void attach(MultipleInsert mi) {
        mi.setTable(this);
        mi.setColumnVector(this.m_cols);
    }

    public boolean insert(MultipleInsert mi, Hashtable<String, String> vals) {
        String insString = mi.insert(vals);
        if (insString != null) {
            try {
                if (this.debug) {
                    this.getSystemErr().println("Entered ms point execute from insert");
                }
                boolean ret = this.execute(insString);
                if (this.debug) {
                    this.getSystemErr().println("Complete ms point execute from insert");
                }
                return ret;
            }
            catch (Exception e) {
                this.getSystemErr().printStackTrace(e);
                return false;
            }
        }
        return true;
    }

    protected boolean doInsert(MultipleInsert mi) {
        String ins = mi.getInsertString();
        if (ins != null) {
            try {
                if (this.debug) {
                    this.getSystemErr().println("Entered ms point execute");
                }
                return this.execute(ins);
            }
            catch (Exception e) {
                this.getSystemErr().printStackTrace(e);
                return false;
            }
        }
        return true;
    }

    public boolean insertComplete(MultipleInsert mi) {
        return this.doInsert(mi);
    }

    protected String getInsertColumnsAsString() {
        String q = "";
        for (int i = 0; i < this.m_cols.size(); ++i) {
            String val = this.m_cols.elementAt(i);
            q = q + val;
            if (i == this.m_cols.size() - 1) continue;
            q = q + ",";
        }
        return q;
    }
}

