/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.application;

import adams.core.ClassLister;
import adams.core.PrintObject;
import adams.core.Utils;
import adams.core.option.OptionUtils;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.AdditionalParameterHandler;
import adams.gui.application.ChildFrame;
import adams.gui.application.ChildWindow;
import adams.gui.application.UserMode;
import adams.gui.core.GUIHelper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;

public abstract class AbstractMenuItemDefinition
implements Serializable {
    private static final long serialVersionUID = -2406133385745656034L;
    public static final String CATEGORY_PROGRAM = "Program";
    public static final String CATEGORY_VISUALIZATION = "Visualization";
    public static final String CATEGORY_TOOLS = "Tools";
    public static final String CATEGORY_MAINTENANCE = "Maintenance";
    public static final String CATEGORY_HELP = "Help";
    protected AbstractApplicationFrame m_Owner;

    public AbstractMenuItemDefinition() {
        this(null);
    }

    public AbstractMenuItemDefinition(AbstractApplicationFrame owner) {
        this.m_Owner = owner;
        this.initialize();
    }

    protected void initialize() {
    }

    public void setOwner(AbstractApplicationFrame value) {
        this.m_Owner = value;
    }

    public AbstractApplicationFrame getOwner() {
        return this.m_Owner;
    }

    public String getIconName() {
        return null;
    }

    public ImageIcon getIcon() {
        ImageIcon result = null;
        if (this.getIconName() != null) {
            result = this.getIconName().indexOf("/") > -1 ? GUIHelper.getExternalIcon(this.getIconName()) : GUIHelper.getIcon(this.getIconName());
        }
        return result;
    }

    public void preLaunch() {
    }

    public abstract void launch();

    public void postLaunch() {
    }

    public JMenuItem getMenuItem() {
        JMenuItem result = new JMenuItem();
        result.setIcon(this.getIcon());
        result.setText(this.getTitle());
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractMenuItemDefinition.this.preLaunch();
                AbstractMenuItemDefinition.this.launch();
                AbstractMenuItemDefinition.this.postLaunch();
            }
        });
        return result;
    }

    public abstract String getTitle();

    public abstract boolean isSingleton();

    public abstract UserMode getUserMode();

    public abstract String getCategory();

    public boolean requiresRestartableApplication() {
        return false;
    }

    protected ChildFrame createChildFrame(Component c) {
        return this.createChildFrame(c, -1, -1);
    }

    protected ChildFrame createChildFrame(Component c, int width, int height) {
        if (this.getOwner() != null) {
            return this.getOwner().createChildFrame(this.getTitle(), c, width, height, this.getIconName());
        }
        return AbstractApplicationFrame.createChildFrame(null, this.getTitle(), c, width, height, this.getIconName());
    }

    protected ChildWindow createChildWindow(Component c) {
        return this.createChildWindow(c, -1, -1);
    }

    protected ChildWindow createChildWindow(Component c, int width, int height) {
        if (this.getOwner() != null) {
            return this.getOwner().createChildWindow(this.getTitle(), c, width, height, this.getIconName());
        }
        return AbstractApplicationFrame.createChildWindow(null, this.getTitle(), c, width, height, this.getIconName());
    }

    protected PrintObject getDebugging() {
        return this.getOwner().getDebugging();
    }

    protected PrintObject getSystemOut() {
        return this.getOwner().getSystemOut();
    }

    protected PrintObject getSystemErr() {
        return this.getOwner().getSystemErr();
    }

    public static String[] getMenuItemDefinitions() {
        return ClassLister.getSingleton().getClassnames(AbstractMenuItemDefinition.class);
    }

    public static AbstractMenuItemDefinition forCommandLine(AbstractApplicationFrame owner, String cmdline) {
        AbstractMenuItemDefinition result;
        try {
            String[] tmp = OptionUtils.splitOptions(cmdline);
            String classname = tmp[0];
            String[] params = new String[tmp.length - 1];
            System.arraycopy(tmp, 1, params, 0, tmp.length - 1);
            result = AbstractMenuItemDefinition.forName(owner, classname, params);
        }
        catch (Exception e) {
            System.err.println("Failed to instantiate menu item definition: " + cmdline);
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractMenuItemDefinition forName(AbstractApplicationFrame owner, String classname, String[] params) {
        AbstractMenuItemDefinition result;
        try {
            Class<?> cls = Class.forName(classname);
            Constructor<?> constr = cls.getConstructor(AbstractApplicationFrame.class);
            result = (AbstractMenuItemDefinition)constr.newInstance(owner);
            if (result instanceof AdditionalParameterHandler) {
                if (params == null) {
                    params = new String[]{};
                }
                ((AdditionalParameterHandler)((Object)result)).setAdditionalParameters(params);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to instantiate menu item definition: " + classname + "/" + Utils.arrayToString(params));
            e.printStackTrace();
            result = null;
        }
        return result;
    }
}

